/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.webapp.runtime;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.enterprise.inject.Vetoed;
import javax.naming.NamingException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wildfly.swarm.topology.Topology;
import org.wildfly.swarm.topology.TopologyListener;

@Vetoed
@WebServlet(urlPatterns={"/system/stream"}, asyncSupported=true)
public class TopologySSEServlet
extends HttpServlet {
    private Topology topology;
    private ScheduledExecutorService keepAliveExecutor;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.topology = Topology.lookup();
        }
        catch (NamingException e) {
            throw new ServletException((Throwable)e);
        }
        this.keepAliveExecutor = Executors.newScheduledThreadPool(2);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/event-stream");
        resp.setCharacterEncoding("UTF-8");
        AsyncContext asyncContext = req.startAsync();
        PrintWriter writer = resp.getWriter();
        SSETopologyListener topologyListener = new SSETopologyListener(writer, req.isSecure());
        ScheduledFuture<?> keepAlive = this.keepAliveExecutor.scheduleAtFixedRate(new KeepAliveRunnable(writer, topologyListener), 10L, 15L, TimeUnit.SECONDS);
        asyncContext.setTimeout(0L);
        asyncContext.addListener((AsyncListener)new TopologyAsyncListener(this.topology, topologyListener, keepAlive));
        this.topology.addListener((TopologyListener)topologyListener);
        String json = this.topologyToJson(req.isSecure());
        writer.write("event: topologyChange\n");
        writer.write("data: " + json);
        writer.flush();
    }

    private String topologyToJson(boolean secure) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        Map map = this.topology.asMap();
        Set keys = map.keySet();
        Iterator keyIter = keys.iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            json.append("  ").append('\"').append(key).append('\"').append(": [");
            List list = (List)map.get(key);
            Iterator listIter = list.iterator();
            String proxyContext = this.getServletContext().getInitParameter(key + "-proxy");
            if (proxyContext != null) {
                ArrayList<String> tags = new ArrayList<String>();
                tags.add(secure ? "https" : "http");
                while (listIter.hasNext()) {
                    Topology.Entry server = (Topology.Entry)listIter.next();
                    tags.add(server.getAddress() + ":" + server.getPort());
                }
                this.populateEndpointAndTagsJson(json, proxyContext, tags);
            } else {
                while (listIter.hasNext()) {
                    Topology.Entry server = (Topology.Entry)listIter.next();
                    boolean invalidServerAddress = false;
                    try {
                        InetAddress.getByName(server.getAddress());
                    }
                    catch (UnknownHostException e) {
                        invalidServerAddress = true;
                    }
                    String endpoint = (!invalidServerAddress ? (server.getTags().contains("https") ? "https" : "http") + "://" : "") + server.getAddress() + ":" + server.getPort();
                    this.populateEndpointAndTagsJson(json, endpoint, server.getTags());
                    if (!listIter.hasNext()) continue;
                    json.append(",");
                }
            }
            json.append("]");
            if (!keyIter.hasNext()) continue;
            json.append(",");
        }
        json.append("}\n\n");
        return json.toString();
    }

    private void populateEndpointAndTagsJson(StringBuilder json, String endpoint, List<String> tags) {
        json.append("{");
        json.append("\"endpoint\": \"").append(endpoint).append("\",");
        json.append("\"tags\":[");
        Iterator<String> tagIter = tags.iterator();
        while (tagIter.hasNext()) {
            String tag = tagIter.next();
            json.append("\"").append(tag).append("\"");
            if (!tagIter.hasNext()) continue;
            json.append(",");
        }
        json.append("]");
        json.append("}");
    }

    private class SSETopologyListener
    implements TopologyListener {
        Object writeLock = new Object();
        final PrintWriter writer;
        final boolean secure;

        private SSETopologyListener(PrintWriter writer, boolean secure) {
            this.writer = writer;
            this.secure = secure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChange(Topology topology) {
            String json = TopologySSEServlet.this.topologyToJson(this.secure);
            Object object = this.writeLock;
            synchronized (object) {
                this.writer.write("event: topologyChange\n");
                this.writer.write("data: " + json);
                this.writer.flush();
            }
        }
    }

    public static class TopologyAsyncListener
    implements AsyncListener {
        private final ScheduledFuture keepAlive;
        private final TopologyListener topologyListener;
        private final Topology topology;

        public TopologyAsyncListener() {
            this.topology = null;
            this.topologyListener = null;
            this.keepAlive = null;
        }

        public TopologyAsyncListener(Topology topology, TopologyListener topologyListener, ScheduledFuture scheduledFuture) {
            this.topology = topology;
            this.topologyListener = topologyListener;
            this.keepAlive = scheduledFuture;
        }

        public void onComplete(AsyncEvent asyncEvent) throws IOException {
            if (this.topology != null) {
                this.topology.removeListener(this.topologyListener);
                this.keepAlive.cancel(true);
            }
        }

        public void onTimeout(AsyncEvent asyncEvent) throws IOException {
            if (this.topology != null) {
                this.topology.removeListener(this.topologyListener);
                this.keepAlive.cancel(true);
            }
        }

        public void onError(AsyncEvent asyncEvent) throws IOException {
            if (this.topology != null) {
                this.topology.removeListener(this.topologyListener);
                this.keepAlive.cancel(true);
            }
        }

        public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
        }
    }

    private class KeepAliveRunnable
    implements Runnable {
        private final PrintWriter writer;
        private final TopologyListener topologyListener;

        public KeepAliveRunnable(PrintWriter writer, TopologyListener topologyListener) {
            this.writer = writer;
            this.topologyListener = topologyListener;
        }

        @Override
        public void run() {
            try {
                this.writer.write(":\n\n");
                this.writer.flush();
            }
            catch (Throwable t) {
                TopologySSEServlet.this.topology.removeListener(this.topologyListener);
                throw t;
            }
        }
    }
}

