/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.impl.base.ArchiveBase;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.wildfly.swarm.container.JARArchive;
import org.wildfly.swarm.msc.ServiceActivatorArchive;
import org.wildfly.swarm.topology.TopologyArchive;

public class TopologyArchiveImpl
extends AssignableBase<ArchiveBase<?>>
implements TopologyArchive {
    public static final String SERVICE_ACTIVATOR_CLASS_NAME = "org.wildfly.swarm.topology.runtime.RegistrationAdvertiserActivator";
    private List<String> serviceNames = new ArrayList<String>();

    public TopologyArchiveImpl(ArchiveBase<?> archive) {
        super(archive);
    }

    protected List<String> getServiceNames() {
        if (!this.serviceNames.isEmpty()) {
            return this.serviceNames;
        }
        String archiveName = ((ArchiveBase)this.getArchive()).getName();
        int lastDotLoc = archiveName.lastIndexOf(46);
        if (lastDotLoc > 0) {
            return Collections.singletonList(archiveName.substring(0, lastDotLoc));
        }
        return Collections.singletonList(archiveName);
    }

    @Override
    public TopologyArchive advertise() {
        this.doAdvertise();
        return this;
    }

    @Override
    public TopologyArchive advertise(String ... serviceNames) {
        for (String serviceName : serviceNames) {
            this.serviceNames.add(serviceName);
        }
        return this.advertise();
    }

    protected TopologyArchive doAdvertise() {
        if (!((ServiceActivatorArchive)this.as(ServiceActivatorArchive.class)).containsServiceActivator(SERVICE_ACTIVATOR_CLASS_NAME)) {
            ((ServiceActivatorArchive)this.as(ServiceActivatorArchive.class)).addServiceActivator(SERVICE_ACTIVATOR_CLASS_NAME);
            ((JARArchive)this.as(JARArchive.class)).addModule("org.wildfly.swarm.topology", "runtime");
        }
        StringBuffer buf = new StringBuffer();
        List<String> names = this.getServiceNames();
        for (String name : names) {
            buf.append(name).append("\n");
        }
        ((JARArchive)this.as(JARArchive.class)).add((Asset)new StringAsset(buf.toString()), "META-INF/swarm-topology-registration.conf");
        return this;
    }
}

