/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.deployment;

import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.inject.Vetoed;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.swarm.topology.TopologyConnector;
import org.wildfly.swarm.topology.TopologyMessages;

@Vetoed
public class RegistrationAdvertiser
implements Service<Void> {
    public static final ServiceName CONNECTOR_SERVICE_NAME = ServiceName.of((String[])new String[]{"swarm", "topology", "connector"});
    private final String name;
    private final String[] tags;
    private InjectedValue<TopologyConnector> topologyConnectorInjector = new InjectedValue();
    private InjectedValue<SocketBinding> socketBindingInjector = new InjectedValue();

    public static ServiceController<Void> install(ServiceTarget target, String serviceName, String socketBindingName, Collection<String> userDefinedTags) {
        ArrayList<String> tags = new ArrayList<String>(userDefinedTags);
        tags.add(socketBindingName);
        ServiceName socketBinding = ServiceName.parse((String)("org.wildfly.network.socket-binding." + socketBindingName));
        RegistrationAdvertiser advertiser = new RegistrationAdvertiser(serviceName, tags.toArray(new String[tags.size()]));
        return target.addService(ServiceName.of((String[])new String[]{"swarm", "topology", "register", serviceName, socketBindingName}), (Service)advertiser).addDependency(CONNECTOR_SERVICE_NAME, TopologyConnector.class, advertiser.getTopologyConnectorInjector()).addDependency(socketBinding, SocketBinding.class, advertiser.getSocketBindingInjector()).setInitialMode(ServiceController.Mode.PASSIVE).install();
    }

    RegistrationAdvertiser(String name, String ... tags) {
        this.name = name;
        this.tags = tags;
    }

    Injector<TopologyConnector> getTopologyConnectorInjector() {
        return this.topologyConnectorInjector;
    }

    Injector<SocketBinding> getSocketBindingInjector() {
        return this.socketBindingInjector;
    }

    public void start(StartContext startContext) throws StartException {
        try {
            ((TopologyConnector)this.topologyConnectorInjector.getValue()).advertise(this.name, (SocketBinding)this.socketBindingInjector.getValue(), this.tags);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext stopContext) {
        try {
            ((TopologyConnector)this.topologyConnectorInjector.getValue()).unadvertise(this.name, (SocketBinding)this.socketBindingInjector.getValue());
        }
        catch (Exception e) {
            TopologyMessages.MESSAGES.errorStoppingAdvertisement(e);
        }
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }
}

