/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.deployment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.enterprise.inject.Vetoed;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.swarm.topology.deployment.RegistrationAdvertiser;

@Vetoed
public class RegistrationAdvertiserActivator
implements ServiceActivator {
    public void activate(ServiceActivatorContext context) throws ServiceRegistryException {
        ServiceTarget target = context.getServiceTarget();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/swarm-topology-registration.conf");
        if (in == null) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String serviceName = null;
            while ((serviceName = reader.readLine()) != null) {
                if ((serviceName = serviceName.trim()).isEmpty()) continue;
                RegistrationAdvertiser.install(target, serviceName, "http");
                RegistrationAdvertiser.install(target, serviceName, "https");
            }
        }
        catch (IOException e) {
            throw new ServiceRegistryException((Throwable)e);
        }
    }
}

