/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.runtime;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.spi.api.ArchiveMetadataProcessor;
import org.wildfly.swarm.topology.Advertise;
import org.wildfly.swarm.topology.Advertises;
import org.wildfly.swarm.topology.TopologyArchive;

@ApplicationScoped
public class AdvertisingMetadataProcessor
implements ArchiveMetadataProcessor {
    public void processArchive(Archive<?> archive, Index index) {
        List annos = index.getAnnotations(DotName.createSimple((String)Advertise.class.getName()));
        List repeatingAnnos = index.getAnnotations(DotName.createSimple((String)Advertises.class.getName()));
        List<String> names = Stream.concat(annos.stream(), repeatingAnnos.stream().flatMap(anno -> Stream.of(anno.value().asNestedArray()))).map(anno -> anno.value().asString()).collect(Collectors.toList());
        if (!names.isEmpty()) {
            ((TopologyArchive)archive.as(TopologyArchive.class)).advertise(names);
        }
    }
}

