/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.spi.api.ArchiveMetadataProcessor;
import org.wildfly.swarm.topology.Advertise;
import org.wildfly.swarm.topology.Advertises;
import org.wildfly.swarm.topology.TopologyArchive;

@ApplicationScoped
public class AdvertisingMetadataProcessor
implements ArchiveMetadataProcessor {
    public void processArchive(Archive<?> archive, Index index) {
        List annos = index.getAnnotations(DotName.createSimple((String)Advertise.class.getName()));
        List repeatingAnnos = index.getAnnotations(DotName.createSimple((String)Advertises.class.getName()));
        Stream.concat(annos.stream(), repeatingAnnos.stream().flatMap(anno -> Stream.of(anno.value().asNestedArray()))).forEach(anno -> this.advertise(archive, (AnnotationInstance)anno));
    }

    private void advertise(Archive<?> archive, AnnotationInstance anno) {
        String serviceName = anno.value().asString();
        List<String> tags = Optional.ofNullable(anno.value("tags")).map(AnnotationValue::asStringArray).map(Arrays::asList).orElse(Collections.emptyList());
        TopologyArchive topologyArchive = (TopologyArchive)archive.as(TopologyArchive.class);
        topologyArchive.advertise(serviceName, tags);
    }
}

