/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.impl.base.ArchiveBase;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.wildfly.swarm.msc.ServiceActivatorArchive;
import org.wildfly.swarm.spi.api.JARArchive;
import org.wildfly.swarm.topology.TopologyArchive;

public class TopologyArchiveImpl
extends AssignableBase<ArchiveBase<?>>
implements TopologyArchive {
    public static final String SERVICE_ACTIVATOR_CLASS_NAME = "org.wildfly.swarm.topology.deployment.RegistrationAdvertiserActivator";
    private Map<String, Collection<String>> tagsByService = new HashMap<String, Collection<String>>();

    public TopologyArchiveImpl(ArchiveBase<?> archive) throws IOException {
        super(archive);
        Node regConf = ((JARArchive)this.as(JARArchive.class)).get("META-INF/swarm-topology-registration.conf");
        if (regConf != null && regConf.getAsset() != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(regConf.getAsset().openStream()));){
                reader.lines().forEach(this::parseConfigLine);
            }
        }
    }

    @Override
    public TopologyArchive advertise() {
        return this.doAdvertise();
    }

    @Override
    public TopologyArchive advertise(String serviceName) {
        return this.advertise(serviceName, Collections.emptyList());
    }

    @Override
    public TopologyArchive advertise(String serviceName, Collection<String> tags) {
        this.tagsByService.put(serviceName, tags);
        return this.doAdvertise();
    }

    @Override
    public List<String> advertisements() {
        ArrayList<String> serviceNames = new ArrayList<String>(this.tagsByService.keySet());
        return Collections.unmodifiableList(serviceNames);
    }

    @Override
    public boolean hasAdvertised() {
        return ((JARArchive)this.as(JARArchive.class)).get("META-INF/swarm-topology-registration.conf") != null;
    }

    private void parseConfigLine(String line) {
        if (!(line = line.trim()).isEmpty()) {
            ArrayList<String> split = new ArrayList<String>(Arrays.asList(line.split(" ")));
            String serviceName = (String)split.get(0);
            List tags = split.size() > 1 ? split.subList(1, split.size()) : Collections.emptyList();
            this.tagsByService.put(serviceName, tags);
        }
    }

    protected List<String> getServiceNames() {
        List<String> result = this.advertisements();
        if (!result.isEmpty()) {
            return result;
        }
        String archiveName = ((ArchiveBase)this.getArchive()).getName();
        int lastDotLoc = archiveName.lastIndexOf(46);
        if (lastDotLoc > 0) {
            return Collections.singletonList(archiveName.substring(0, lastDotLoc));
        }
        return Collections.singletonList(archiveName);
    }

    protected TopologyArchive doAdvertise() {
        if (!((ServiceActivatorArchive)this.as(ServiceActivatorArchive.class)).containsServiceActivator(SERVICE_ACTIVATOR_CLASS_NAME)) {
            ((ServiceActivatorArchive)this.as(ServiceActivatorArchive.class)).addServiceActivator(SERVICE_ACTIVATOR_CLASS_NAME);
        }
        StringBuilder registrationConf = new StringBuilder();
        List<String> names = this.getServiceNames();
        for (String name : names) {
            Collection tags = this.tagsByService.getOrDefault(name, Collections.emptyList());
            registrationConf.append(name);
            if (!tags.isEmpty()) {
                registrationConf.append(" ").append(tags.stream().collect(Collectors.joining(",")));
            }
            registrationConf.append("\n");
        }
        ((JARArchive)this.as(JARArchive.class)).add((Asset)new StringAsset(registrationConf.toString()), "META-INF/swarm-topology-registration.conf");
        return this;
    }
}

