/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.runtime;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;
import org.wildfly.swarm.topology.Advertise;
import org.wildfly.swarm.topology.Advertises;
import org.wildfly.swarm.topology.TopologyArchive;

@DeploymentScoped
public class AdvertisingMetadataProcessor
implements DeploymentProcessor {
    final Archive archive;
    final IndexView index;

    @Inject
    public AdvertisingMetadataProcessor(Archive archive, IndexView index) {
        this.archive = archive;
        this.index = index;
    }

    public void process() {
        Collection annos = this.index.getAnnotations(DotName.createSimple((String)Advertise.class.getName()));
        Collection repeatingAnnos = this.index.getAnnotations(DotName.createSimple((String)Advertises.class.getName()));
        Stream.concat(annos.stream(), repeatingAnnos.stream().flatMap(anno -> Stream.of(anno.value().asNestedArray()))).forEach(anno -> this.advertise((Archive<?>)this.archive, (AnnotationInstance)anno));
    }

    private void advertise(Archive<?> archive, AnnotationInstance anno) {
        String serviceName = anno.value().asString();
        List<String> tags = Optional.ofNullable(anno.value("tags")).map(AnnotationValue::asStringArray).map(Arrays::asList).orElse(Collections.emptyList());
        TopologyArchive topologyArchive = (TopologyArchive)archive.as(TopologyArchive.class);
        topologyArchive.advertise(serviceName, tags);
    }
}

