/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.swarm.topology.AdvertisementHandle;
import org.wildfly.swarm.topology.Topology;
import org.wildfly.swarm.topology.TopologyListener;
import org.wildfly.swarm.topology.TopologyMessages;
import org.wildfly.swarm.topology.deployment.RegistrationAdvertiser;
import org.wildfly.swarm.topology.runtime.AdvertisementHandleImpl;
import org.wildfly.swarm.topology.runtime.Registration;

public class TopologyManager
implements Topology {
    public static final TopologyManager INSTANCE = new TopologyManager();
    private List<TopologyListener> listeners = new ArrayList<TopologyListener>();
    private List<Registration> registrations = new ArrayList<Registration>();
    private Executor executor = Executors.newFixedThreadPool(2);
    private ServiceTarget serviceTarget;

    public void setServiceTarget(ServiceTarget serviceTarget) {
        this.serviceTarget = serviceTarget;
    }

    @Override
    public synchronized void addListener(TopologyListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(TopologyListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public AdvertisementHandle advertise(String name, String ... tags) {
        ServiceController<Void> httpAdvert = RegistrationAdvertiser.install(this.serviceTarget, name, "http", Arrays.asList(tags));
        ServiceController<Void> httpsAdvert = RegistrationAdvertiser.install(this.serviceTarget, name, "https", Arrays.asList(tags));
        return new AdvertisementHandleImpl(httpAdvert, httpsAdvert);
    }

    public synchronized Set<Registration> registrationsForSourceKey(String sourceKey) {
        Set<Registration> result = Collections.unmodifiableSet(this.registrations.stream().filter(e -> e.getSourceKey().equals(sourceKey)).collect(Collectors.toSet()));
        return result;
    }

    public synchronized Set<Registration> registrationsForService(String name) {
        Set<Registration> result = Collections.unmodifiableSet(this.registrations.stream().filter(e -> e.getName().equals(name)).collect(Collectors.toSet()));
        return result;
    }

    public synchronized Set<Registration> registrationsForService(String name, String tag) {
        Set<Registration> result = Collections.unmodifiableSet(this.registrations.stream().filter(e -> e.getName().equals(name) && e.hasTag(tag)).collect(Collectors.toSet()));
        return result;
    }

    public synchronized void register(Registration registration) {
        if (!this.registrations.contains(registration)) {
            this.registrations.add(registration);
            this.fireListeners();
        }
    }

    public synchronized void unregister(Registration registration) {
        boolean removed = this.registrations.removeIf(e -> e.equals(registration));
        if (removed) {
            this.fireListeners();
        }
    }

    public synchronized void unregisterAll(String sourceKey) {
        boolean removed = this.registrations.removeIf(e -> e.getSourceKey().equals(sourceKey));
        if (removed) {
            this.fireListeners();
        }
    }

    public synchronized void unregisterAll(String sourceKey, String name) {
        boolean removed = this.registrations.removeIf(e -> e.getSourceKey().equals(sourceKey) && e.getName().equals(name));
        if (removed) {
            this.fireListeners();
        }
    }

    @Override
    public synchronized Map<String, List<Topology.Entry>> asMap() {
        HashMap<String, List<Topology.Entry>> map = new HashMap<String, List<Topology.Entry>>();
        for (Registration registration : this.registrations) {
            ArrayList<Registration> list = (ArrayList<Registration>)map.get(registration.getName());
            if (list == null) {
                list = new ArrayList<Registration>();
                map.put(registration.getName(), list);
            }
            list.add(registration);
        }
        return map;
    }

    private void fireListeners() {
        ArrayList<TopologyListener> currentListeners = new ArrayList<TopologyListener>();
        currentListeners.addAll(this.listeners);
        currentListeners.forEach(e -> this.executor.execute(() -> {
            try {
                e.onChange(this);
            }
            catch (Throwable t) {
                TopologyMessages.MESSAGES.errorFiringEvent(e.getClass().getName(), t);
                this.removeListener((TopologyListener)e);
            }
        }));
    }
}

