/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.topology.deployment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.inject.Vetoed;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.swarm.topology.deployment.RegistrationAdvertiser;

@Vetoed
public class RegistrationAdvertiserActivator
implements ServiceActivator {
    public void activate(ServiceActivatorContext context) throws ServiceRegistryException {
        ServiceTarget target = context.getServiceTarget();
        this.forEachLine("META-INF/swarm-topology-registration.conf", registrationLine -> {
            int separatorIndex = registrationLine.indexOf(" ");
            String serviceName = registrationLine;
            List<String> tags = Collections.emptyList();
            if (separatorIndex > 0) {
                serviceName = registrationLine.substring(0, separatorIndex);
                tags = this.getTags(registrationLine.substring(separatorIndex + 1));
            }
            RegistrationAdvertiser.install(target, serviceName, "http", tags);
            RegistrationAdvertiser.install(target, serviceName, "https", tags);
        });
    }

    private List<String> getTags(String tagsAsString) {
        return Stream.of(tagsAsString.split(",")).map(String::trim).collect(Collectors.toList());
    }

    private void forEachLine(String resourceName, Consumer<String> consumer) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        if (in == null) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                consumer.accept(line.trim());
            }
        }
        catch (IOException e) {
            throw new ServiceRegistryException((Throwable)e);
        }
    }
}

