/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.descriptors;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.javaee7.ParamValueType;
import org.jboss.shrinkwrap.descriptor.api.webapp31.WebAppDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webcommon31.LoginConfigType;
import org.jboss.shrinkwrap.descriptor.api.webcommon31.SecurityConstraintType;
import org.wildfly.swarm.spi.api.ClassLoading;
import org.wildfly.swarm.undertow.descriptors.SecurityConstraint;

public class WebXmlAsset
implements NamedAsset {
    public static final String NAME = "WEB-INF/web.xml";
    private final WebAppDescriptor descriptor;
    private List<SecurityConstraint> constraints = new ArrayList<SecurityConstraint>();

    public WebXmlAsset() {
        this.descriptor = (WebAppDescriptor)ClassLoading.withTCCL((ClassLoader)Descriptors.class.getClassLoader(), () -> (WebAppDescriptor)Descriptors.create(WebAppDescriptor.class));
    }

    public WebXmlAsset(InputStream fromStream) {
        this.descriptor = (WebAppDescriptor)ClassLoading.withTCCL((ClassLoader)Descriptors.class.getClassLoader(), () -> (WebAppDescriptor)Descriptors.importAs(WebAppDescriptor.class).fromStream(fromStream));
    }

    public void setContextParam(String name, String ... values) {
        this.descriptor.createContextParam().paramName(name).paramValue(this.convert(values));
    }

    public String getContextParam(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        Optional<ParamValueType> paramValue = this.descriptor.getAllContextParam().stream().filter(p -> p.getParamName().equals(name)).findFirst();
        return paramValue.isPresent() ? paramValue.get().getParamValue() : null;
    }

    public void setLoginConfig(String authMethod, String realmName) {
        this.descriptor.createLoginConfig().authMethod(authMethod).realmName(realmName);
    }

    public String getLoginRealm(String authMethod) {
        if (authMethod == null || authMethod.length() == 0) {
            return null;
        }
        Optional<LoginConfigType> loginConfig = this.descriptor.getAllLoginConfig().stream().filter(l -> l.getAuthMethod().equals(authMethod)).findFirst();
        return loginConfig.isPresent() ? loginConfig.get().getRealmName() : null;
    }

    public SecurityConstraint protect() {
        SecurityConstraint constraint = new SecurityConstraint();
        this.constraints.add(constraint);
        return constraint;
    }

    public SecurityConstraint protect(String urlPattern) {
        SecurityConstraint constraint = new SecurityConstraint(urlPattern);
        this.constraints.add(constraint);
        return constraint;
    }

    public InputStream openStream() {
        HashSet<String> allRoles = new HashSet<String>();
        for (SecurityConstraint each : this.constraints) {
            ((SecurityConstraintType)this.descriptor.createSecurityConstraint().createWebResourceCollection().urlPattern(new String[]{each.urlPattern()}).httpMethod(each.methods().toArray(new String[each.methods().size()])).up()).getOrCreateAuthConstraint().roleName(each.roles().toArray(new String[each.roles().size()])).up();
            allRoles.addAll(each.roles());
        }
        for (String eachRole : allRoles) {
            this.descriptor.getOrCreateSecurityRole().roleName(eachRole);
        }
        return new ByteArrayInputStream(this.descriptor.exportAsString().getBytes());
    }

    public String getName() {
        return NAME;
    }

    private String convert(String ... values) {
        StringBuilder builder = new StringBuilder();
        boolean addedFirst = false;
        for (String value : values) {
            if (addedFirst) {
                builder.append(',');
            }
            builder.append(value);
            addedFirst = true;
        }
        return builder.toString();
    }
}

