/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.internal;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.wildfly.swarm.spi.api.DefaultDeploymentFactory;
import org.wildfly.swarm.spi.api.DependenciesContainer;
import org.wildfly.swarm.undertow.WARArchive;

public class DefaultWarDeploymentFactory
extends DefaultDeploymentFactory {
    public static WARArchive archiveFromCurrentApp() throws Exception {
        WARArchive archive = (WARArchive)ShrinkWrap.create(WARArchive.class, (String)DefaultWarDeploymentFactory.determineName());
        DefaultWarDeploymentFactory factory = new DefaultWarDeploymentFactory();
        factory.setup(archive);
        archive.addModule("org.wildfly.swarm.undertow", "runtime");
        return archive;
    }

    public int getPriority() {
        return 0;
    }

    public String getType() {
        return "war";
    }

    public Archive create() throws Exception {
        return DefaultWarDeploymentFactory.archiveFromCurrentApp();
    }

    public boolean setupUsingMaven(Archive<?> givenArchive) throws Exception {
        Path webapp;
        final DependenciesContainer archive = (DependenciesContainer)givenArchive;
        Path pwd = Paths.get(System.getProperty("user.dir"), new String[0]);
        final Path classes = pwd.resolve("target").resolve("classes");
        boolean success = false;
        if (Files.exists(classes, new LinkOption[0])) {
            success = true;
            Files.walkFileTree(classes, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path simple = classes.relativize(file);
                    archive.add((Asset)new FileAsset(file.toFile()), "WEB-INF/classes/" + DefaultWarDeploymentFactory.this.convertSeparators(simple));
                    if (simple.toString().contains("WEB-INF")) {
                        archive.add((Asset)new FileAsset(file.toFile()), DefaultWarDeploymentFactory.this.convertSeparators(simple));
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        if (Files.exists(webapp = pwd.resolve("src").resolve("main").resolve("webapp"), new LinkOption[0])) {
            success = true;
            Files.walkFileTree(webapp, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path simple = webapp.relativize(file);
                    archive.add((Asset)new FileAsset(file.toFile()), DefaultWarDeploymentFactory.this.convertSeparators(simple));
                    return super.visitFile(file, attrs);
                }
            });
        }
        archive.addAllDependencies();
        return success;
    }

    protected static String determineName() {
        return DefaultDeploymentFactory.determineName((String)".war");
    }
}

