/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.api.asset.Asset;

public class UndertowExternalMountsAsset
implements Asset {
    private List<String> externalMounts = new ArrayList<String>();

    public UndertowExternalMountsAsset() {
    }

    public UndertowExternalMountsAsset(InputStream inputStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.externalMount(line);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading Undertow external mounts conf", ex);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void externalMount(String path) {
        this.externalMounts.add(path);
    }

    public InputStream openStream() {
        StringBuilder conf = new StringBuilder();
        for (String each : this.externalMounts) {
            conf.append(each + "\n");
        }
        return new ByteArrayInputStream(conf.toString().getBytes());
    }
}

