/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow;

import java.util.List;
import org.wildfly.swarm.SwarmProperties;
import org.wildfly.swarm.config.ManagementCoreService;
import org.wildfly.swarm.config.Undertow;
import org.wildfly.swarm.config.undertow.BufferCache;
import org.wildfly.swarm.config.undertow.HandlerConfiguration;
import org.wildfly.swarm.config.undertow.Server;
import org.wildfly.swarm.config.undertow.ServletContainer;
import org.wildfly.swarm.config.undertow.server.HTTPListener;
import org.wildfly.swarm.config.undertow.server.Host;
import org.wildfly.swarm.config.undertow.servlet_container.JSPSetting;
import org.wildfly.swarm.config.undertow.servlet_container.WebsocketsSetting;
import org.wildfly.swarm.container.Container;
import org.wildfly.swarm.container.Fraction;
import org.wildfly.swarm.container.SocketBinding;

public class UndertowFraction
extends Undertow<UndertowFraction>
implements Fraction {
    private String keystorePath;
    private String keystorePassword;
    private String alias;

    public static UndertowFraction createDefaultFraction() {
        UndertowFraction fraction = new UndertowFraction();
        ((UndertowFraction)((UndertowFraction)((UndertowFraction)fraction.server(new Server("default-server").httpListener(new HTTPListener("default").socketBinding("http")).host(new Host("default-host")))).bufferCache(new BufferCache("default"))).servletContainer(new ServletContainer("default").websocketsSetting(new WebsocketsSetting()).jspSetting(new JSPSetting()))).handlerConfiguration(new HandlerConfiguration());
        return fraction;
    }

    public static UndertowFraction createDefaultFractionWithMonitor() {
        UndertowFraction fraction = UndertowFraction.createDefaultFraction();
        fraction.filterConfiguration();
        fraction.subresources().filterConfiguration().customFilter("wfs-monitor", customFilter -> {
            customFilter.module("org.wildfly.swarm.monitor:runtime");
            customFilter.className("org.wildfly.swarm.monitor.runtime.MonitorEndpoints");
        });
        fraction.subresources().server("default-server").subresources().host("default-host").filterRef("wfs-monitor");
        return fraction;
    }

    public static UndertowFraction createDefaultFraction(String path, String password, String alias) {
        return UndertowFraction.createDefaultFraction().enableHTTPS(path, password, alias);
    }

    public static UndertowFraction createDefaultHTTPSOnlyFraction(String path, String password, String alias) {
        UndertowFraction fraction = new UndertowFraction();
        fraction.enableHTTPS(path, password, alias);
        return fraction;
    }

    public UndertowFraction enableHTTPS(String path, String password, String alias) {
        this.keystorePath = path;
        this.keystorePassword = password;
        this.alias = alias;
        return this;
    }

    public void initialize(Container.InitContext initContext) {
        initContext.socketBinding(new SocketBinding("http").port(SwarmProperties.propertyVar((String)"swarm.http.port", (String)"8080")));
        initContext.socketBinding(new SocketBinding("https").port(SwarmProperties.propertyVar((String)"swarm.https.port", (String)"8443")));
    }

    public void postInitialize(Container.PostInitContext initContext) {
        if (this.keystorePassword != null & this.keystorePassword != null && this.alias != null) {
            ManagementCoreService management = (ManagementCoreService)initContext.fraction("management");
            if (management == null) {
                throw new RuntimeException("HTTPS configured but org.wildfly.swarm:management not available");
            }
            List servers = this.subresources().servers();
            for (Server server : servers) {
                if (!server.subresources().httpsListeners().isEmpty() || !server.subresources().httpListener("default").socketBinding().equals("http")) continue;
                server.httpsListener("default-https", listener -> {
                    listener.securityRealm("SSLRealm");
                    listener.socketBinding("https");
                });
            }
            management.securityRealm("SSLRealm", realm -> realm.sslServerIdentity(identity -> {
                identity.keystorePath(this.keystorePath);
                identity.keystorePassword(this.keystorePassword);
                identity.alias(this.alias);
            }));
        }
    }
}

