/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.runtime;

import javax.enterprise.inject.Any;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.SocketBinding;
import org.wildfly.swarm.spi.api.SocketBindingGroup;
import org.wildfly.swarm.spi.runtime.annotations.ConfigurationValue;
import org.wildfly.swarm.spi.runtime.annotations.Pre;
import org.wildfly.swarm.undertow.UndertowFraction;

@Pre
@Singleton
public class UndertowSocketBindingsCustomizer
implements Customizer {
    @Inject
    @Named(value="standard-sockets")
    private SocketBindingGroup group;
    @Inject
    @Any
    UndertowFraction fraction;
    @Inject
    @ConfigurationValue(value="swarm.http.port")
    Integer httpPort;
    @Inject
    @ConfigurationValue(value="swarm.https.port")
    Integer httpsPort;

    public void customize() {
        if (this.httpPort == null) {
            this.httpPort = this.fraction.httpPort();
        }
        if (this.httpsPort == null) {
            this.httpsPort = this.fraction.httpsPort();
        }
        this.group.socketBinding(new SocketBinding("http").port(this.httpPort.intValue()));
        this.group.socketBinding(new SocketBinding("https").port(this.httpsPort.intValue()));
    }
}

