/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.runtime;

import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.wildfly.swarm.config.ManagementCoreService;
import org.wildfly.swarm.config.undertow.Server;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Pre;
import org.wildfly.swarm.undertow.UndertowFraction;
import org.wildfly.swarm.undertow.descriptors.CertInfo;

@Pre
@Singleton
public class HTTPSCustomizer
implements Customizer {
    @Inject
    private UndertowFraction undertow;
    @Inject
    @Any
    private Instance<ManagementCoreService> managementCoreService;
    @Inject
    private CertInfo certInfo;

    public void customize() {
        if (!this.managementCoreService.isUnsatisfied() && this.certInfo.isValid()) {
            ManagementCoreService management = (ManagementCoreService)this.managementCoreService.get();
            if (management == null) {
                throw SwarmMessages.MESSAGES.httpsRequiresManagementFraction();
            }
            for (Server server : this.undertow.subresources().servers()) {
                if (!server.subresources().httpsListeners().isEmpty()) continue;
                server.httpsListener("default-https", listener -> listener.securityRealm("SSLRealm").socketBinding("https"));
            }
            management.securityRealm("SSLRealm", realm -> realm.sslServerIdentity(identity -> identity.keystorePath(this.certInfo.keystorePath()).keystoreRelativeTo(this.certInfo.keystoreRelativeTo()).keystorePassword(this.certInfo.keystorePassword()).keyPassword(this.certInfo.keyPassword()).alias(this.certInfo.keystoreAlias()).generateSelfSignedCertificateHost(this.certInfo.generateSelfSignedCertificateHost())));
        }
    }
}

