/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.runtime;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.wildfly.swarm.config.ManagementCoreService;
import org.wildfly.swarm.config.undertow.Server;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Pre;
import org.wildfly.swarm.undertow.UndertowFraction;

@Pre
@ApplicationScoped
public class HTTPSCustomizer
implements Customizer {
    @Inject
    @Any
    private Instance<UndertowFraction> undertowInstance;
    @Inject
    @Any
    private Instance<ManagementCoreService> managementCoreService;

    public void customize() {
        UndertowFraction fraction;
        if (!this.managementCoreService.isUnsatisfied() && (fraction = (UndertowFraction)((Object)this.undertowInstance.get())).keystorePassword() != null & fraction.keystorePassword() != null && fraction.alias() != null) {
            ManagementCoreService management = (ManagementCoreService)this.managementCoreService.get();
            if (management == null) {
                throw new RuntimeException("HTTPS configured but org.wildfly.swarm:management not available");
            }
            List servers = fraction.subresources().servers();
            for (Server server : servers) {
                if (!server.subresources().httpsListeners().isEmpty()) continue;
                server.httpsListener("default-https", listener -> {
                    listener.securityRealm("SSLRealm");
                    listener.socketBinding("https");
                });
            }
            management.securityRealm("SSLRealm", realm -> realm.sslServerIdentity(identity -> {
                identity.keystorePath(fraction.keystorePath());
                identity.keystorePassword(fraction.keystorePassword());
                identity.alias(fraction.alias());
            }));
        }
    }
}

