/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.runtime;

import java.io.File;
import java.io.IOException;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.wildfly.swarm.bootstrap.util.TempFileManager;
import org.wildfly.swarm.spi.runtime.annotations.ConfigurationValue;
import org.wildfly.swarm.undertow.UndertowFraction;
import org.wildfly.swarm.undertow.descriptors.CertInfo;

public class CertInfoProducer {
    @Inject
    @Any
    private Instance<UndertowFraction> undertowInstance;
    @Inject
    @ConfigurationValue(value="swarm.https.certificate.generate")
    private Boolean generateSelfCertificate;
    @Inject
    @ConfigurationValue(value="swarm.https.certificate.generate.host")
    private String selfCertificateHost;

    @Produces
    @Singleton
    public CertInfo produceCertInfo() {
        if (this.undertowInstance.isUnsatisfied()) {
            return CertInfo.INVALID;
        }
        UndertowFraction undertowFraction = (UndertowFraction)((Object)this.undertowInstance.get());
        if (this.generateSelfCertificate != null && this.generateSelfCertificate.booleanValue()) {
            if (System.getProperty("jboss.server.data.dir") == null) {
                File tmpDir = null;
                try {
                    tmpDir = TempFileManager.INSTANCE.newTempDirectory("wildfly-swarm-data", ".d");
                    System.setProperty("jboss.server.data.dir", tmpDir.getAbsolutePath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return new CertInfo(this.selfCertificateHost, "jboss.server.data.dir");
        }
        String keystorePath = undertowFraction.keystorePath();
        String keystorePassword = undertowFraction.keystorePassword();
        String keyPassword = undertowFraction.keyPassword();
        String keystoreAlias = undertowFraction.alias();
        return new CertInfo(keystorePath, keystorePassword, keyPassword, keystoreAlias);
    }
}

