/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow;

import org.wildfly.swarm.config.Undertow;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.undertow.BufferCache;
import org.wildfly.swarm.config.undertow.HandlerConfiguration;
import org.wildfly.swarm.config.undertow.Server;
import org.wildfly.swarm.config.undertow.ServletContainer;
import org.wildfly.swarm.config.undertow.server.Host;
import org.wildfly.swarm.config.undertow.servlet_container.JSPSetting;
import org.wildfly.swarm.config.undertow.servlet_container.WebsocketsSetting;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.api.annotations.MarshalDMR;
import org.wildfly.swarm.spi.api.annotations.WildFlyExtension;

@MarshalDMR
@WildFlyExtension(module="org.wildfly.extension.undertow")
public class UndertowFraction
extends Undertow<UndertowFraction>
implements Fraction {
    @Configurable(value="swarm.http.port")
    @AttributeDocumentation(value="Set the port for the default HTTP listener")
    private Defaultable<Integer> httpPort = Defaultable.integer((int)8080);
    @Configurable(value="swarm.https.port")
    @AttributeDocumentation(value="Set the port for the default HTTPS listener")
    private Defaultable<Integer> httpsPort = Defaultable.integer((int)8443);
    @Configurable(value="swarm.ajp.port")
    @AttributeDocumentation(value="Set the port for the default AJP listener")
    private Defaultable<Integer> ajpPort = Defaultable.integer((int)8009);
    @Configurable(value="swarm.http.keystore.path")
    @AttributeDocumentation(value="Path to the server keystore")
    private String keystorePath;
    @Configurable(value="swarm.http.keystore.password")
    @AttributeDocumentation(value="Password to the server keystore")
    private String keystorePassword;
    @Configurable(value="swarm.http.key.password")
    @AttributeDocumentation(value="Password to the server certificate")
    private String keyPassword;
    @Configurable(value="swarm.http.certificate.alias")
    @AttributeDocumentation(value="Alias to the server certificate")
    private String alias;
    @Configurable(value="swarm.ajp.enable")
    @AttributeDocumentation(value="Determine if AJP should be enabled")
    private Defaultable<Boolean> enableAJP = Defaultable.ifAnyExplicitlySet((Defaultable[])new Defaultable[]{this.ajpPort});

    public static UndertowFraction createDefaultFraction() {
        UndertowFraction fraction = new UndertowFraction();
        return fraction.applyDefaults();
    }

    public UndertowFraction applyDefaults() {
        ((UndertowFraction)((UndertowFraction)((UndertowFraction)this.server(new Server("default-server").httpListener("default", listener -> listener.socketBinding("http")).host(new Host("default-host")))).bufferCache(new BufferCache("default"))).servletContainer(new ServletContainer("default").websocketsSetting(new WebsocketsSetting()).jspSetting(new JSPSetting()))).handlerConfiguration(new HandlerConfiguration());
        return this;
    }

    public static UndertowFraction createDefaultFraction(String path, String password, String alias) {
        return UndertowFraction.createDefaultFraction().enableHTTPS(path, password, alias);
    }

    public static UndertowFraction createDefaultAndEnableAJPFraction() {
        return UndertowFraction.createDefaultFraction().enableAJP();
    }

    public static UndertowFraction createDefaultHTTPSOnlyFraction(String path, String password, String alias) {
        UndertowFraction fraction = UndertowFraction.createDefaultFraction();
        fraction.removeHttpListenersFromDefaultServer().enableHTTPS(path, password, alias);
        return fraction;
    }

    public static UndertowFraction createDefaultAJPOnlyFraction() {
        UndertowFraction fraction = UndertowFraction.createDefaultFraction();
        fraction.removeHttpListenersFromDefaultServer().enableAJP();
        return fraction;
    }

    public UndertowFraction enableHTTPS(String path, String password, String alias) {
        return this.enableHTTPS(path, password, password, alias);
    }

    public UndertowFraction enableHTTPS(String path, String keystorePassword, String keyPassword, String alias) {
        this.keystorePath = path;
        this.keystorePassword = keystorePassword;
        this.keyPassword = keyPassword;
        this.alias = alias;
        return this;
    }

    public UndertowFraction enableAJP() {
        this.enableAJP.set((Object)true);
        return this;
    }

    public String keystorePassword() {
        return this.keystorePassword;
    }

    public String keyPassword() {
        return this.keyPassword;
    }

    public String keystorePath() {
        return this.keystorePath;
    }

    public String alias() {
        return this.alias;
    }

    public boolean isEnableAJP() {
        return (Boolean)this.enableAJP.get();
    }

    private UndertowFraction removeHttpListenersFromDefaultServer() {
        this.subresources().server("default-server").subresources().httpListeners().clear();
        return this;
    }

    public UndertowFraction httpPort(int httpPort) {
        this.httpPort.set((Object)httpPort);
        return this;
    }

    public int httpPort() {
        return (Integer)this.httpPort.get();
    }

    public UndertowFraction httpsPort(int httpsPort) {
        this.httpsPort.set((Object)httpsPort);
        return this;
    }

    public int httpsPort() {
        return (Integer)this.httpsPort.get();
    }

    public UndertowFraction ajpPort(int ajpPort) {
        this.ajpPort.set((Object)ajpPort);
        return this;
    }

    public int ajpPort() {
        return (Integer)this.ajpPort.get();
    }
}

