/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.runtime;

import java.io.File;
import java.io.IOException;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.wildfly.swarm.bootstrap.util.TempFileManager;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.undertow.UndertowFraction;
import org.wildfly.swarm.undertow.descriptors.CertInfo;

public class CertInfoProducer {
    @Inject
    UndertowFraction undertow;
    @Configurable(value="swarm.https.certificate.generate")
    Defaultable<Boolean> generateSelfCertificate = Defaultable.bool((boolean)false);
    @Configurable(value="swarm.https.certificate.generate.host")
    Defaultable<String> selfCertificateHost = Defaultable.string((String)"localhost");

    @Produces
    @Singleton
    public CertInfo produceCertInfo() {
        if (((Boolean)this.generateSelfCertificate.get()).booleanValue()) {
            if (System.getProperty("jboss.server.data.dir") == null) {
                File tmpDir = null;
                try {
                    tmpDir = TempFileManager.INSTANCE.newTempDirectory("wildfly-swarm-data", ".d");
                    System.setProperty("jboss.server.data.dir", tmpDir.getAbsolutePath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return new CertInfo((String)this.selfCertificateHost.get(), "jboss.server.data.dir");
        }
        String keystorePath = this.undertow.keystorePath();
        String keystorePassword = this.undertow.keystorePassword();
        String keyPassword = this.undertow.keyPassword();
        String keystoreAlias = this.undertow.alias();
        return new CertInfo(keystorePath, keystorePassword, keyPassword, keystoreAlias);
    }
}

