/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.wildfly.swarm.SwarmInfo;
import org.wildfly.swarm.bootstrap.util.TempFileManager;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.undertow.UndertowFraction;
import org.wildfly.swarm.undertow.descriptors.CertInfo;

@ApplicationScoped
public class CertInfoProducer {
    public static final String JBOSS_DATA_DIR = "jboss.server.data.dir";
    @Inject
    UndertowFraction undertow;
    @Configurable(value="swarm.https.certificate.generate")
    Defaultable<Boolean> generateSelfCertificate = Defaultable.bool((boolean)false);
    @Configurable(value="swarm.https.certificate.generate.host")
    Defaultable<String> selfCertificateHost = Defaultable.string((String)"localhost");
    @Configurable(value="swarm.https.keystore.embedded")
    Defaultable<Boolean> embeddedKeystore = Defaultable.bool((boolean)false);

    @Produces
    @Singleton
    public CertInfo produceCertInfo() {
        if (((Boolean)this.generateSelfCertificate.get()).booleanValue()) {
            if (SwarmInfo.isProduct()) {
                throw SwarmMessages.MESSAGES.generateSelfSignedCertificateNotSupported();
            }
            this.checkDataDir();
            return new CertInfo((String)this.selfCertificateHost.get(), JBOSS_DATA_DIR);
        }
        String keystorePath = this.undertow.keystorePath();
        if (((Boolean)this.embeddedKeystore.get()).booleanValue()) {
            this.checkDataDir();
            Path dataDir = Paths.get(System.getProperty(JBOSS_DATA_DIR), new String[0]);
            Path certDestination = dataDir.resolve(keystorePath);
            try {
                Module appModule = Module.getCallerModuleLoader().loadModule(ModuleIdentifier.create((String)"swarm.application"));
                URL jks = appModule.getClassLoader().getResource(keystorePath);
                Files.copy(jks.openStream(), certDestination, new CopyOption[0]);
                keystorePath = certDestination.toString();
            }
            catch (Exception ie) {
                throw new RuntimeException("Error copying embedded certificate", ie);
            }
        }
        String keystorePassword = this.undertow.keystorePassword();
        String keyPassword = this.undertow.keyPassword();
        String keystoreAlias = this.undertow.alias();
        return new CertInfo(keystorePath, keystorePassword, keyPassword, keystoreAlias);
    }

    protected void checkDataDir() {
        if (System.getProperty(JBOSS_DATA_DIR) == null) {
            File tmpDir = null;
            try {
                tmpDir = TempFileManager.INSTANCE.newTempDirectory("wildfly-swarm-data", ".d");
                System.setProperty(JBOSS_DATA_DIR, tmpDir.getAbsolutePath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

