/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.runtime;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.spi.api.ArchivePreparer;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.undertow.WARArchive;
import org.wildfly.swarm.undertow.descriptors.JBossWebAsset;
import org.wildfly.swarm.undertow.descriptors.SecurityConstraint;
import org.wildfly.swarm.undertow.descriptors.WebXmlAsset;

@ApplicationScoped
public class HttpSecurityPreparer
implements ArchivePreparer {
    private static final Logger LOG = Logger.getLogger(HttpSecurityPreparer.class);
    private final String[] SUPPORTED_AUTH_METHODS = new String[]{"BASIC", "DIGEST", "FORM", "KEYCLOAK"};
    @Configurable(value="swarm.deployment")
    Map<String, Object> deploymentConfigs;

    public void prepareArchive(Archive<?> archive) {
        if (this.deploymentConfigs == null || this.deploymentConfigs.isEmpty()) {
            return;
        }
        Optional<String> match = this.deploymentConfigs.keySet().stream().filter(c -> archive.getName().equals(c)).findFirst();
        if (!match.isPresent()) {
            return;
        }
        Map matchingConfig = (Map)this.deploymentConfigs.get(match.get());
        if (!matchingConfig.containsKey("web")) {
            return;
        }
        Map deploymentConfig = (Map)matchingConfig.get("web");
        Map loginConfig = (Map)deploymentConfig.get("login-config");
        String authMethod = loginConfig.getOrDefault("auth-method", "NONE");
        boolean isSupported = false;
        for (String supported : this.SUPPORTED_AUTH_METHODS) {
            if (!authMethod.equals(supported)) continue;
            isSupported = true;
            break;
        }
        if (!isSupported) {
            LOG.warn((Object)("Ignoring unsupported auth-method: " + authMethod));
            return;
        }
        WARArchive war = (WARArchive)archive.as(WARArchive.class);
        WebXmlAsset webXml = war.findWebXmlAsset();
        JBossWebAsset jbossWeb = war.findJbossWebAsset();
        webXml.setLoginConfig(authMethod, "ignored");
        if (loginConfig.containsKey("security-domain")) {
            jbossWeb.setSecurityDomain((String)loginConfig.get("security-domain"));
        }
        if (loginConfig.containsKey("form-login-config")) {
            Map formLoginConfig = (Map)loginConfig.get("form-login-config");
            webXml.setFormLoginConfig("Security Realm", (String)formLoginConfig.get("form-login-page"), (String)formLoginConfig.get("form-error-page"));
        }
        List securityConstraints = deploymentConfig.getOrDefault("security-constraints", Collections.EMPTY_LIST);
        for (Map sc : securityConstraints) {
            SecurityConstraint securityConstraint = webXml.protect(sc.getOrDefault("url-pattern", "/*"));
            sc.getOrDefault("methods", Collections.emptyList()).forEach(securityConstraint::withMethod);
            sc.getOrDefault("roles", Collections.emptyList()).forEach(securityConstraint::withRole);
        }
    }
}

