/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.descriptors;

import io.undertow.servlet.ServletExtension;
import java.io.IOException;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.api.container.ServiceProviderContainer;
import org.wildfly.swarm.spi.api.JBossDeploymentStructureContainer;
import org.wildfly.swarm.undertow.descriptors.FaviconFactory;
import org.wildfly.swarm.undertow.descriptors.Servlet;
import org.wildfly.swarm.undertow.descriptors.WebXmlAsset;

public interface WebXmlContainer<T extends Archive<T>>
extends Archive<T>,
ServiceProviderContainer<T>,
JBossDeploymentStructureContainer<T> {
    default public T addContextParam(String name, String ... values) {
        this.findWebXmlAsset().setContextParam(name, values);
        return (T)this;
    }

    default public String getContextParamValue(String name) {
        return this.findWebXmlAsset().getContextParam(name);
    }

    default public T addFaviconExceptionHandler() throws IOException {
        String path = "WEB-INF/classes/" + "org.wildfly.swarm.generated.FaviconServletExtension".replace('.', '/') + ".class";
        byte[] generatedExtension = FaviconFactory.createFaviconServletExtension("org.wildfly.swarm.generated.FaviconServletExtension");
        this.add((Asset)new ByteArrayAsset(generatedExtension), path);
        path = "WEB-INF/classes/" + "org.wildfly.swarm.generated.FaviconErrorHandler".replace('.', '/') + ".class";
        byte[] generatedHandler = FaviconFactory.createFaviconErrorHandler("org.wildfly.swarm.generated.FaviconErrorHandler");
        this.add((Asset)new ByteArrayAsset(generatedHandler), path);
        this.addAsServiceProvider(ServletExtension.class.getName(), new String[]{"org.wildfly.swarm.generated.FaviconServletExtension"});
        this.addModule("org.jboss.modules");
        return (T)this;
    }

    default public Servlet addServlet(String servletName, String servletClass) {
        return this.findWebXmlAsset().addServlet(servletName, servletClass);
    }

    default public Servlet servlet(String servletClass) {
        return this.findWebXmlAsset().getServlet(servletClass);
    }

    default public WebXmlAsset findWebXmlAsset() {
        WebXmlAsset asset;
        Node webXml = this.get("WEB-INF/web.xml");
        if (webXml == null) {
            asset = new WebXmlAsset();
            this.add(asset);
        } else {
            Asset tempAsset = webXml.getAsset();
            if (!(tempAsset instanceof WebXmlAsset)) {
                asset = new WebXmlAsset(tempAsset.openStream());
                this.add(asset);
            } else {
                asset = (NamedAsset)tempAsset;
            }
        }
        return asset;
    }
}

