/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.runtime;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.spi.api.ArchivePreparer;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.undertow.WARArchive;
import org.wildfly.swarm.undertow.internal.UndertowExternalMountsAsset;

@ApplicationScoped
public class ContextPathArchivePreparer
implements ArchivePreparer {
    @AttributeDocumentation(value="Web context path for the default deployment")
    @Configurable(value="swarm.context.path")
    Defaultable<String> contextPath = Defaultable.string((String)"/");
    @AttributeDocumentation(value="List of content mounts")
    @Configurable(value="swarm.context.mounts")
    List<String> mounts;

    public void prepareArchive(Archive<?> archive) {
        WARArchive warArchive = (WARArchive)archive.as(WARArchive.class);
        if (warArchive.getContextRoot() == null) {
            warArchive.setContextRoot((String)this.contextPath.get());
        }
        UndertowExternalMountsAsset ut = null;
        if (this.mounts != null) {
            for (String mountPath : this.mounts) {
                Path staticPath = Paths.get(mountPath, new String[0]);
                if (!staticPath.isAbsolute()) {
                    staticPath = Paths.get(System.getProperty("user.dir"), staticPath.toString()).normalize();
                }
                if (ut == null) {
                    ut = new UndertowExternalMountsAsset();
                }
                ut.externalMount(staticPath.toString());
            }
        }
        if (ut != null) {
            warArchive.add(ut, "WEB-INF/undertow-external-mounts.conf");
        }
    }
}

