/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.descriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SecurityConstraint {
    private final String urlPattern;
    private List<String> methods = new ArrayList<String>();
    private List<String> roles = new ArrayList<String>();

    public SecurityConstraint() {
        this("/*");
    }

    public SecurityConstraint(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public String urlPattern() {
        return this.urlPattern;
    }

    public SecurityConstraint withMethod(String method) {
        this.methods.add(method);
        return this;
    }

    public SecurityConstraint withMethod(String ... methods) {
        this.methods.addAll(Arrays.asList(methods));
        return this;
    }

    public List<String> methods() {
        return this.methods;
    }

    public SecurityConstraint withRole(String role) {
        this.roles.add(role);
        return this;
    }

    public SecurityConstraint withRole(String ... roles) {
        this.roles.addAll(Arrays.asList(roles));
        return this;
    }

    public List<String> roles() {
        return this.roles;
    }
}

