/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.wildfly.swarm.config.ManagementCoreService;
import org.wildfly.swarm.config.management.security_realm.SslServerIdentity;
import org.wildfly.swarm.config.undertow.Server;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Pre;
import org.wildfly.swarm.undertow.UndertowFraction;
import org.wildfly.swarm.undertow.descriptors.CertInfo;

@Pre
@ApplicationScoped
public class HTTPSCustomizer
implements Customizer {
    @Inject
    UndertowFraction undertow;
    @Inject
    @Any
    Instance<ManagementCoreService> managementCoreService;
    @Inject
    CertInfo certInfo;

    public void customize() {
        if (!this.managementCoreService.isUnsatisfied() && this.certInfo.isValid()) {
            ManagementCoreService management = (ManagementCoreService)this.managementCoreService.get();
            if (management == null) {
                throw SwarmMessages.MESSAGES.httpsRequiresManagementFraction();
            }
            if (this.undertow.isOnlyHTTPS()) {
                this.undertow.removeHttpListenersFromDefaultServer();
            }
            management.securityRealm("SSLRealm", realm -> realm.sslServerIdentity(identity -> {
                identity.keystorePath(this.certInfo.keystorePath()).keystoreRelativeTo(this.certInfo.keystoreRelativeTo()).keystorePassword(this.certInfo.keystorePassword()).keyPassword(this.certInfo.keyPassword()).alias(this.certInfo.keystoreAlias()).alias(this.certInfo.keystoreAlias());
                this.handleSelfSignedCertificateHost(identity);
            }));
            for (Server server : this.undertow.subresources().servers()) {
                if (!server.subresources().httpsListeners().isEmpty()) continue;
                server.httpsListener("default-https", listener -> {
                    listener.securityRealm("SSLRealm");
                    listener.socketBinding("https");
                });
            }
        }
    }

    private void handleSelfSignedCertificateHost(SslServerIdentity identity) {
        try {
            Method genMethod = identity.getClass().getMethod("generateSelfSignedCertificateHost", String.class);
            genMethod.invoke((Object)identity, this.certInfo.generateSelfSignedCertificateHost());
        }
        catch (NoSuchMethodException genMethod) {
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            SwarmMessages.MESSAGES.failToInvokeGenerateSelfSignedCertificateHost((Throwable)e);
        }
    }
}

