/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.internal;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class FaviconErrorHandler
implements HttpHandler {
    private volatile HttpHandler next;

    public FaviconErrorHandler(HttpHandler next) {
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        boolean faviconHandled = false;
        if (!exchange.isResponseComplete() && exchange.getRequestPath().contains("favicon.ico")) {
            try (InputStream faviconStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("favicon.ico");){
                if (faviconStream != null) {
                    faviconHandled = this.writeFavicon(faviconStream, exchange);
                }
            }
            if (!faviconHandled) {
                Module module = Module.getBootModuleLoader().loadModule("org.wildfly.swarm.undertow:runtime");
                ModuleClassLoader cl = module.getClassLoader();
                try (InputStream in = cl.getResourceAsStream("favicon-default.ico");){
                    if (in != null) {
                        faviconHandled = this.writeFavicon(in, exchange);
                    }
                }
            }
        }
        if (!faviconHandled) {
            this.next.handleRequest(exchange);
        }
    }

    private boolean writeFavicon(InputStream inputStream, HttpServerExchange exchange) throws IOException {
        if (inputStream != null) {
            exchange.startBlocking();
            OutputStream os = exchange.getOutputStream();
            byte[] buffer = new byte[1024];
            while (inputStream.read(buffer) > -1) {
                os.write(buffer);
            }
            exchange.endExchange();
            return true;
        }
        return false;
    }
}

