/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.webservices;

import org.wildfly.swarm.config.Webservices;
import org.wildfly.swarm.config.webservices.EndpointConfig;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.MarshalDMR;
import org.wildfly.swarm.spi.api.annotations.WildFlyExtension;

@WildFlyExtension(module="org.jboss.as.webservices")
@MarshalDMR
public class WebServicesFraction
extends Webservices<WebServicesFraction>
implements Fraction<WebServicesFraction> {
    private static final String STANDARD_ENDPOINT_CONFIG = "Standard-Endpoint-Config";
    private static final String RECORDING_ENDPOINT_CONFIG = "Recording-Endpoint-Config";
    private static final String RECORDING_HANDLERS = "recording-handlers";
    private static final String SOAP_PROTOCOLS = "##SOAP11_HTTP ##SOAP11_HTTP_MTOM ##SOAP12_HTTP ##SOAP12_HTTP_MTOM";
    private static final String RECORDING_HANDLER = "RecordingHandler";
    private static final String RECORDING_HANDLER_CLASS = "org.jboss.ws.common.invocation.RecordingServerHandler";
    private static final String STANDARD_CLIENT_CONFIG = "Standard-Client-Config";

    public static WebServicesFraction createDefaultFraction() {
        return new WebServicesFraction().applyDefaults();
    }

    public WebServicesFraction applyDefaults() {
        this.endpointConfig(STANDARD_ENDPOINT_CONFIG);
        this.endpointConfig(RECORDING_ENDPOINT_CONFIG, this::configureRemoteEndpoint);
        this.clientConfig(STANDARD_CLIENT_CONFIG);
        return this;
    }

    private void configureRemoteEndpoint(EndpointConfig<?> endpoint) {
        endpoint.preHandlerChain(RECORDING_HANDLERS, chain -> chain.protocolBindings(SOAP_PROTOCOLS).handler(RECORDING_HANDLER, handler -> handler.attributeClass(RECORDING_HANDLER_CLASS)));
    }
}

