/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenChecksumPolicy;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepositories;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepository;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenUpdatePolicy;
import org.wildfly.swarm.arquillian.adapter.ArquillianArtifactResolvingHelper;
import org.wildfly.swarm.arquillian.adapter.WildFlySwarmContainerConfiguration;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.BuildTool;

public class WildFlySwarmContainer
implements DeployableContainer<WildFlySwarmContainerConfiguration> {
    private Class<?> testClass;
    private List<String> requestedMavenArtifacts;
    private Process process;
    private LatchedBridge stdout;
    private IOBridge stderr;

    public Class<WildFlySwarmContainerConfiguration> getConfigurationClass() {
        return WildFlySwarmContainerConfiguration.class;
    }

    public void setup(WildFlySwarmContainerConfiguration config) {
    }

    public void start() throws LifecycleException {
    }

    public void stop() throws LifecycleException {
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public void setTestClass(Class<?> testClass) {
        this.testClass = testClass;
    }

    public void setRequestedMavenArtifacts(List<String> artifacts) {
        this.requestedMavenArtifacts = artifacts;
    }

    public boolean isContainerFactory(Class<?> cls) {
        if (cls.getName().equals("org.wildfly.swarm.ContainerFactory")) {
            return true;
        }
        for (Class<?> interf : cls.getInterfaces()) {
            if (!this.isContainerFactory(interf)) continue;
            return true;
        }
        if (cls.getSuperclass() != null) {
            return this.isContainerFactory(cls.getSuperclass());
        }
        return false;
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        boolean hasRequestedArtifacts;
        if (this.isContainerFactory(this.testClass)) {
            ((JavaArchive)archive.as(JavaArchive.class)).addAsServiceProvider("org.wildfly.swarm.ContainerFactory", new String[]{this.testClass.getName()});
            ((JavaArchive)archive.as(JavaArchive.class)).addClass(this.testClass);
        }
        BuildTool tool = new BuildTool();
        tool.projectArchive(archive);
        MavenRemoteRepository jbossPublic = MavenRemoteRepositories.createRemoteRepository((String)"jboss-public-repository-group", (String)"http://repository.jboss.org/nexus/content/groups/public/", (String)"default");
        jbossPublic.setChecksumPolicy(MavenChecksumPolicy.CHECKSUM_POLICY_IGNORE);
        jbossPublic.setUpdatePolicy(MavenUpdatePolicy.UPDATE_POLICY_NEVER);
        ConfigurableMavenResolverSystem resolver = (ConfigurableMavenResolverSystem)((ConfigurableMavenResolverSystem)Maven.configureResolver().withMavenCentralRepo(true)).withRemoteRepo(jbossPublic);
        tool.artifactResolvingHelper((ArtifactResolvingHelper)new ArquillianArtifactResolvingHelper(resolver));
        boolean bl = hasRequestedArtifacts = this.requestedMavenArtifacts != null && this.requestedMavenArtifacts.size() > 0;
        if (!hasRequestedArtifacts) {
            MavenResolvedArtifact[] deps;
            for (MavenResolvedArtifact dep : deps = (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)((PomEquippedResolveStage)resolver.loadPomFromFile("pom.xml")).importRuntimeAndTestDependencies()).resolve()).withTransitivity()).asResolvedArtifact()) {
                MavenCoordinate coord = dep.getCoordinate();
                tool.dependency(dep.getScope().name(), coord.getGroupId(), coord.getArtifactId(), coord.getVersion(), coord.getPackaging().getExtension(), coord.getClassifier(), dep.asFile());
            }
        } else {
            for (String requestedDep : this.requestedMavenArtifacts) {
                MavenResolvedArtifact[] deps;
                for (MavenResolvedArtifact dep : deps = (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)resolver.loadPomFromFile("pom.xml")).resolve(requestedDep)).withTransitivity()).asResolvedArtifact()) {
                    MavenCoordinate coord = dep.getCoordinate();
                    tool.dependency(dep.getScope().name(), coord.getGroupId(), coord.getArtifactId(), coord.getVersion(), coord.getPackaging().getExtension(), coord.getClassifier(), dep.asFile());
                }
            }
        }
        try {
            Path java = this.findJava();
            if (java == null) {
                throw new DeploymentException("Unable to locate `java` binary");
            }
            Archive wrapped = tool.build();
            File executable = File.createTempFile("arquillian", "-swarm.jar");
            ((ZipExporter)wrapped.as(ZipExporter.class)).exportTo(executable, true);
            executable.deleteOnExit();
            ArrayList<String> cli = new ArrayList<String>();
            cli.add(java.toString());
            cli.add("-Djava.net.preferIPv4Stack=true");
            Enumeration<?> names = System.getProperties().propertyNames();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                if (!key.startsWith("jboss") && !key.startsWith("swarm") && !key.startsWith("wildfly")) continue;
                String value = System.getProperty(key);
                cli.add("-D" + key + "=" + value);
            }
            cli.add("-jar");
            cli.add(executable.getAbsolutePath());
            this.process = Runtime.getRuntime().exec(cli.toArray(new String[cli.size()]));
            CountDownLatch latch = new CountDownLatch(1);
            this.stdout = new LatchedBridge("out", latch, this.process.getInputStream(), System.out);
            this.stderr = new LatchedBridge("err", latch, this.process.getErrorStream(), System.err);
            this.process.getOutputStream().close();
            new Thread(this.stdout).start();
            new Thread(this.stderr).start();
            ProtocolMetaData metaData = new ProtocolMetaData();
            HTTPContext context = new HTTPContext("localhost", 8080);
            context.add(new Servlet("ArquillianServletRunner", "/"));
            metaData.addContext((Object)context);
            latch.await();
            return metaData;
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        try {
            try {
                this.stdout.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.stderr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.process.destroy();
            this.process.waitFor(10L, TimeUnit.SECONDS);
            this.process.destroyForcibly();
            this.process.waitFor(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
    }

    private Path findJava() {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            return null;
        }
        Path binDir = FileSystems.getDefault().getPath(javaHome, "bin");
        Path java = binDir.resolve("java.exe");
        if (java.toFile().exists()) {
            return java;
        }
        java = binDir.resolve("java");
        if (java.toFile().exists()) {
            return java;
        }
        return null;
    }

    private static class LatchedBridge
    extends IOBridge {
        private final CountDownLatch latch;

        public LatchedBridge(String name, CountDownLatch latch, InputStream in, OutputStream out) {
            super(name, in, out);
            this.latch = latch;
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }

        @Override
        protected void processLine(String line) throws IOException {
            super.processLine(line);
            if (line.contains("WFLYSRV0010")) {
                this.latch.countDown();
            }
        }
    }

    private static class IOBridge
    implements Runnable {
        private final String name;
        private final InputStream in;
        private final OutputStream out;

        public IOBridge(String name, InputStream in, OutputStream out) {
            this.name = name;
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    this.processLine(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected void processLine(String line) throws IOException {
            this.out.write(line.getBytes());
            this.out.write(10);
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

