/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;
import org.wildfly.swarm.arquillian.adapter.CompleteableTransferListener;

public class FailureReportingTransferListener
extends AbstractTransferListener
implements CompleteableTransferListener {
    private final Map<TransferResource, List<TransferEvent>> transfers = new HashMap<TransferResource, List<TransferEvent>>();

    public void transferSucceeded(TransferEvent event) {
        this.transfers.remove(event.getResource());
    }

    public void transferFailed(TransferEvent event) {
        TransferResource resource = event.getResource();
        List<TransferEvent> events = this.transfers.get(resource);
        if (events == null) {
            events = new ArrayList<TransferEvent>();
            this.transfers.put(resource, events);
        }
        events.add(event);
    }

    @Override
    public void complete() {
        if (this.hasFailures()) {
            System.err.print(this.failuresAsString());
            this.transfers.clear();
        }
    }

    public boolean hasFailures() {
        return !this.transfers.isEmpty();
    }

    public String failuresAsString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<TransferResource, List<TransferEvent>> entry : this.transfers.entrySet()) {
            TransferResource resource = entry.getKey();
            for (TransferEvent event : entry.getValue()) {
                sb.append("Failed").append(event.getRequestType() == TransferEvent.RequestType.PUT ? " uploading " : " downloading ").append(resource.getResourceName()).append(event.getRequestType() == TransferEvent.RequestType.PUT ? " into " : " from ").append(resource.getRepositoryUrl()).append(". ");
                if (event.getException() != null) {
                    sb.append("Reason: \n").append(event.getException());
                }
                sb.append('\n');
            }
        }
        return sb.toString();
    }
}

