/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.adapter;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.transfer.TransferListener;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSessionContainer;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSessionImpl;
import org.wildfly.swarm.arquillian.adapter.CompleteableTransferListener;
import org.wildfly.swarm.arquillian.adapter.FailureReportingTransferListener;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;

public class ShrinkwrapArtifactResolvingHelper
implements ArtifactResolvingHelper {
    private final ConfigurableMavenResolverSystem resolver;
    private CompleteableTransferListener transferListener;
    private RepositoryListener repositoryListener;

    public ShrinkwrapArtifactResolvingHelper(ConfigurableMavenResolverSystem resolver) {
        this.resolver = resolver;
        this.transferListener(new FailureReportingTransferListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactSpec resolve(ArtifactSpec spec) {
        this.resetListeners();
        try {
            if (spec.file != null) {
                ArtifactSpec artifactSpec = spec;
                return artifactSpec;
            }
            File file = ((MavenFormatStage)((MavenStrategyStage)this.resolver.resolve(spec.coordinates())).withoutTransitivity()).asSingleFile();
            if (file == null) {
                ArtifactSpec artifactSpec = null;
                return artifactSpec;
            }
            spec.file = file;
        }
        finally {
            this.completeTransferListener();
        }
        return spec;
    }

    public Set<ArtifactSpec> resolveAll(Set<ArtifactSpec> specs) {
        MavenResolvedArtifact[] artifacts;
        this.resetListeners();
        try {
            artifacts = (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)this.resolver.resolve((Collection)specs.stream().map(ArtifactSpec::coordinates).collect(Collectors.toList()))).withTransitivity()).as(MavenResolvedArtifact.class);
        }
        finally {
            this.completeTransferListener();
        }
        return Arrays.stream(artifacts).map(artifact -> {
            MavenCoordinate coord = artifact.getCoordinate();
            return new ArtifactSpec("compile", coord.getGroupId(), coord.getArtifactId(), coord.getVersion(), coord.getPackaging().getId(), coord.getClassifier(), artifact.asFile());
        }).collect(Collectors.toSet());
    }

    public ShrinkwrapArtifactResolvingHelper repositoryListener(RepositoryListener l) {
        this.repositoryListener = l;
        return this;
    }

    public ShrinkwrapArtifactResolvingHelper transferListener(CompleteableTransferListener l) {
        this.transferListener = l;
        return this;
    }

    private void resetListeners() {
        DefaultRepositorySystemSession session = this.session();
        session.setRepositoryListener(this.repositoryListener);
        session.setTransferListener((TransferListener)this.transferListener);
    }

    private void completeTransferListener() {
        if (this.transferListener != null) {
            this.transferListener.complete();
        }
    }

    private DefaultRepositorySystemSession session() {
        MavenWorkingSession session = ((MavenWorkingSessionContainer)this.resolver).getMavenWorkingSession();
        try {
            Field innerSession = MavenWorkingSessionImpl.class.getDeclaredField("session");
            innerSession.setAccessible(true);
            return (DefaultRepositorySystemSession)innerSession.get(session);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to access maven session", e);
        }
    }
}

