/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.jboss.modules.ArtifactLoaderFactory;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.JarFileResourceLoader;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ModuleXmlParser;
import org.jboss.modules.ProjectDependencies;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.StreamUtil;
import org.jboss.modules.Util;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;

public class BootModuleFinder
implements ModuleFinder {
    JarFile jarFile = Util.rootJar();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleSpec findModule(ModuleIdentifier identifier, ModuleLoader delegateLoader) throws ModuleLoadException {
        ModuleSpec moduleSpec;
        if (identifier.getName().equals("APP")) {
            try {
                return this.findAppModule(identifier.getSlot());
            }
            catch (IOException e) {
                throw new ModuleLoadException((Throwable)e);
            }
        }
        String namePath = identifier.getName().replace('.', '/');
        String basePath = "modules/system/layers/base/" + namePath + "/" + identifier.getSlot();
        JarEntry moduleXmlEntry = this.jarFile.getJarEntry(basePath + "/module.xml");
        if (moduleXmlEntry == null) {
            return null;
        }
        try {
            InputStream inputStream = this.jarFile.getInputStream(moduleXmlEntry);
            try {
                moduleSpec = ModuleXmlParser.parseModuleXml(new ModuleXmlParser.ResourceRootFactory(){

                    @Override
                    public ResourceLoader createResourceLoader(String rootPath, String loaderPath, String loaderName) throws IOException {
                        return new JarFileResourceLoader(loaderName, BootModuleFinder.this.jarFile, rootPath + "/" + loaderPath);
                    }
                }, basePath, inputStream, moduleXmlEntry.getName(), delegateLoader, identifier);
            }
            finally {
                StreamUtil.safeClose((Closeable)inputStream);
            }
        }
        catch (IOException e) {
            throw new ModuleLoadException("Failed to read module.xml file", (Throwable)e);
        }
        return moduleSpec;
    }

    private ModuleSpec findAppModule(String slot) throws IOException {
        if (slot.equals("main")) {
            return this.findAppModule_main();
        }
        if (slot.equals("dependencies")) {
            return this.findAppModule_dependencies();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModuleSpec findAppModule_main() throws IOException {
        Manifest manifest = Util.rootJar().getManifest();
        String artifactName = manifest.getMainAttributes().getValue("Application-Artifact");
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("app/" + artifactName);
        ModuleSpec.Builder builder = ModuleSpec.build((ModuleIdentifier)ModuleIdentifier.create("APP"));
        if (in == null) {
            return null;
        }
        String rootName = artifactName;
        String extension = ".jar";
        int dotLoc = artifactName.lastIndexOf(".");
        if (dotLoc >= 0) {
            rootName = artifactName.substring(0, dotLoc);
            extension = artifactName.substring(dotLoc);
        }
        try {
            JarFileResourceLoader resourceLoader;
            File tmp = File.createTempFile(rootName, extension);
            try (FileOutputStream out = new FileOutputStream(tmp);){
                byte[] buf = new byte[1024];
                int len = -1;
                while ((len = in.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                }
            }
            if (artifactName.endsWith(".war")) {
                resourceLoader = new JarFileResourceLoader(artifactName, new JarFile(tmp), "WEB-INF/classes");
                ResourceLoaderSpec resourceLoaderSpec = ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)resourceLoader);
                builder.addResourceRoot(resourceLoaderSpec);
            }
            resourceLoader = new JarFileResourceLoader(artifactName, new JarFile(tmp));
            ResourceLoaderSpec resourceLoaderSpec = ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)resourceLoader);
            builder.addResourceRoot(resourceLoaderSpec);
            System.setProperty("wildfly.swarm.app.path", tmp.getAbsolutePath());
            System.setProperty("wildfly.swarm.app.name", artifactName);
        }
        finally {
            in.close();
        }
        builder.addDependency(DependencySpec.createLocalDependencySpec());
        builder.addDependency(DependencySpec.createModuleDependencySpec((ModuleIdentifier)ModuleIdentifier.create("org.wildfly.swarm.container"), (boolean)false));
        builder.addDependency(DependencySpec.createModuleDependencySpec((ModuleIdentifier)ModuleIdentifier.create("APP", "dependencies"), (boolean)false));
        String modulesStr = manifest.getMainAttributes().getValue("Feature-Pack-Modules");
        String[] modules = modulesStr.split(",");
        for (int i = 0; i < modules.length; ++i) {
            String[] parts = modules[i].trim().split(":");
            builder.addDependency(DependencySpec.createModuleDependencySpec((PathFilter)PathFilters.acceptAll(), (PathFilter)PathFilters.getMetaInfServicesFilter(), null, (ModuleIdentifier)ModuleIdentifier.create(parts[0], parts[1]), (boolean)false));
        }
        ModuleSpec moduleSpec = builder.create();
        return moduleSpec;
    }

    private ModuleSpec findAppModule_dependencies() throws IOException {
        ModuleSpec.Builder builder = ModuleSpec.build((ModuleIdentifier)ModuleIdentifier.create("APP", "dependencies"));
        JarFile rootJar = Util.rootJar();
        ZipEntry depsTxt = rootJar.getEntry("dependencies.txt");
        if (depsTxt != null) {
            ProjectDependencies deps = ProjectDependencies.initialize(rootJar.getInputStream(depsTxt));
            Set<String> gavs = deps.getGAVs();
            for (String each : gavs) {
                ResourceLoader loader = ArtifactLoaderFactory.INSTANCE.getLoader(each);
                builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)loader));
            }
        }
        builder.addDependency(DependencySpec.createLocalDependencySpec());
        ModuleSpec moduleSpec = builder.create();
        return moduleSpec;
    }
}

