/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class Extractor {
    public static Path extract(JarFile jar, String path) throws IOException {
        ZipEntry entry = jar.getEntry(path);
        if (entry == null) {
            return null;
        }
        int slashLoc = path.lastIndexOf(47);
        String name = path;
        if (slashLoc > 0) {
            name = path.substring(slashLoc + 1);
        }
        String ext = ".jar";
        int dotLoc = name.lastIndexOf(46);
        if (dotLoc > 0) {
            ext = name.substring(dotLoc);
            name = name.substring(0, dotLoc);
        }
        Path tmp = Files.createTempFile(name, ext, new FileAttribute[0]);
        try (InputStream in = jar.getInputStream(entry);){
            Files.copy(in, tmp, StandardCopyOption.REPLACE_EXISTING);
        }
        return tmp;
    }
}

