/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public class Layout {
    private static ClassLoader BOOTSTRAP_CLASSLOADER = null;

    public static boolean isFatJar() throws IOException {
        block29: {
            Path root = Layout.getRoot();
            if (Files.isRegularFile(root, new LinkOption[0])) {
                try (JarFile jar = new JarFile(root.toFile());){
                    ZipEntry propsEntry = jar.getEntry("META-INF/wildfly-swarm.properties");
                    if (propsEntry == null) break block29;
                    try (InputStream in = jar.getInputStream(propsEntry);){
                        Properties props = new Properties();
                        props.load(in);
                        if (props.containsKey("wildfly.swarm.app.artifact")) {
                            System.setProperty("wildfly.swarm.app.artifact", props.getProperty("wildfly.swarm.app.artifact"));
                        }
                        Enumeration<?> names = props.propertyNames();
                        while (names.hasMoreElements()) {
                            String name = (String)names.nextElement();
                            String value = props.getProperty(name);
                            if (System.getProperty(name) != null) continue;
                            System.setProperty(name, value);
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public static Path getRoot() throws IOException {
        URL location = Layout.class.getProtectionDomain().getCodeSource().getLocation();
        if (location.getProtocol().equals("file")) {
            try {
                return Paths.get(location.toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        throw new IOException("Unable to determine root");
    }

    public static Manifest getManifest() throws IOException {
        Path root = Layout.getRoot();
        if (Layout.isFatJar()) {
            try (JarFile jar = new JarFile(root.toFile());){
                ZipEntry entry = jar.getEntry("META-INF/MANIFEST.MF");
                if (entry != null) {
                    InputStream in = jar.getInputStream(entry);
                    Manifest manifest = new Manifest(in);
                    return manifest;
                }
            }
        }
        return null;
    }

    public static synchronized ClassLoader getBootstrapClassLoader() throws ModuleLoadException {
        if (BOOTSTRAP_CLASSLOADER == null) {
            try {
                BOOTSTRAP_CLASSLOADER = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create("org.wildfly.swarm.bootstrap")).getClassLoader();
            }
            catch (ModuleLoadException e) {
                BOOTSTRAP_CLASSLOADER = Layout.class.getClassLoader();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return BOOTSTRAP_CLASSLOADER;
    }
}

