/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.modules;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.jar.JarFile;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.MavenArtifactUtil;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.modules.filter.ClassFilters;
import org.jboss.modules.filter.PathFilters;
import org.wildfly.swarm.bootstrap.util.Layout;

public class ApplicationModuleFinder
implements ModuleFinder {
    @Override
    public ModuleSpec findModule(ModuleIdentifier identifier, ModuleLoader delegateLoader) throws ModuleLoadException {
        ModuleSpec.Builder builder;
        block16: {
            if (!identifier.getName().equals("swarm.application")) {
                return null;
            }
            builder = ModuleSpec.build(identifier);
            try {
                if (Layout.isFatJar()) {
                    this.gatherJarsFromJar(builder);
                    break block16;
                }
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                Enumeration<URL> results = cl.getResources("wildfly-swarm-bootstrap.conf");
                while (results.hasMoreElements()) {
                    URL each = results.nextElement();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(each.openStream()));
                    Throwable throwable = null;
                    try {
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            if ((line = line.trim()).isEmpty()) continue;
                            builder.addDependency(DependencySpec.createModuleDependencySpec(PathFilters.acceptAll(), PathFilters.acceptAll(), PathFilters.acceptAll(), PathFilters.acceptAll(), ClassFilters.acceptAll(), ClassFilters.acceptAll(), null, ModuleIdentifier.create(line), false));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                throw new ModuleLoadException(e);
            }
        }
        builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.jboss.modules")));
        builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.jboss.msc")));
        builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.jboss.shrinkwrap")));
        builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.wildfly.swarm.configuration")));
        builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("javax.api")));
        builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("sun.jdk")));
        builder.addDependency(DependencySpec.createModuleDependencySpec(PathFilters.acceptAll(), PathFilters.acceptAll(), PathFilters.acceptAll(), PathFilters.acceptAll(), ClassFilters.acceptAll(), ClassFilters.acceptAll(), null, ModuleIdentifier.create("org.wildfly.swarm.container", "api"), false));
        builder.addDependency(DependencySpec.createLocalDependencySpec());
        return builder.create();
    }

    protected void gatherJarsFromJar(ModuleSpec.Builder builder) throws IOException {
        InputStream bootstrapTxt = this.getClass().getClassLoader().getResourceAsStream("META-INF/wildfly-swarm-application.conf");
        if (bootstrapTxt != null) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(bootstrapTxt));){
                String line = null;
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    if (line.startsWith("module:")) {
                        line = line.substring(7);
                        builder.addDependency(DependencySpec.createModuleDependencySpec(PathFilters.acceptAll(), PathFilters.acceptAll(), PathFilters.acceptAll(), PathFilters.acceptAll(), ClassFilters.acceptAll(), ClassFilters.acceptAll(), null, ModuleIdentifier.create(line), false));
                        continue;
                    }
                    if (line.startsWith("gav:")) {
                        File artifact = MavenArtifactUtil.resolveJarArtifact(line = line.substring(4).trim());
                        if (artifact == null) {
                            throw new IOException("Unable to locate artifact: " + line);
                        }
                        builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(ResourceLoaders.createJarResourceLoader(artifact.getName(), new JarFile(artifact))));
                        continue;
                    }
                    if (!line.startsWith("path:")) continue;
                    line = line.substring(5).trim();
                    int slashLoc = line.lastIndexOf(47);
                    String name = line;
                    if (slashLoc > 0) {
                        name = line.substring(slashLoc + 1);
                    }
                    String ext = ".jar";
                    int dotLoc = name.lastIndexOf(46);
                    if (dotLoc > 0) {
                        ext = name.substring(dotLoc);
                        name = name.substring(0, dotLoc);
                    }
                    Path tmp = Files.createTempFile(name, ext, new FileAttribute[0]);
                    try (InputStream artifactIn = this.getClass().getClassLoader().getResourceAsStream(line);){
                        Files.copy(artifactIn, tmp, StandardCopyOption.REPLACE_EXISTING);
                    }
                    builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(ResourceLoaders.createJarResourceLoader(tmp.getFileName().toString(), new JarFile(tmp.toFile()))));
                }
            }
        }
    }
}

