/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenChecksumPolicy;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepositories;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepository;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenUpdatePolicy;
import org.wildfly.swarm.arquillian.adapter.ShrinkwrapArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.BuildTool;
import org.wildfly.swarm.tools.PackageDetector;

public class Build {
    private final Set<String> swarmDependencies = new HashSet<String>();
    private File source;
    private File outputDir;
    private String name;
    private String version;

    public Build() {
        this.swarmDependencies.add("bootstrap");
        this.swarmDependencies.add("container");
    }

    public Build source(File source) {
        this.source = source;
        return this;
    }

    public Build outputDir(File dir) {
        this.outputDir = dir;
        return this;
    }

    public Build addSwarmDependencies(List<String> deps) {
        this.swarmDependencies.addAll(deps);
        return this;
    }

    public Build name(String name) {
        this.name = name;
        return this;
    }

    public Build swarmVersion(String v) {
        this.version = v;
        return this;
    }

    private Map<String, Set<String>> fractionPackages() throws IOException {
        Properties fractionPackages = new Properties();
        InputStream in = Build.class.getResourceAsStream("/org/wildfly/swarm/cli/fraction-packages.properties");
        Object object = null;
        try {
            if (in == null) {
                throw new RuntimeException("Failed to load fraction-packages.properties");
            }
            fractionPackages.load(in);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (object != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        HashMap<String, Set<String>> fractionMap = new HashMap<String, Set<String>>();
        for (Map.Entry entry : fractionPackages.entrySet()) {
            HashSet<String> packages = new HashSet<String>();
            packages.addAll(Arrays.asList(((String)entry.getValue()).split(",")));
            fractionMap.put((String)entry.getKey(), packages);
        }
        return fractionMap;
    }

    private Set<String> detectNeededFractions() throws IOException {
        Map<String, Set<String>> fractionPackages = this.fractionPackages();
        return PackageDetector.detectPackages((ZipFile)new ZipFile(this.source)).stream().map(pkg -> {
            for (Map.Entry entry : fractionPackages.entrySet()) {
                if (!((Set)entry.getValue()).contains(pkg)) continue;
                return (String)entry.getKey();
            }
            return null;
        }).filter(v -> v != null).collect(Collectors.toSet());
    }

    public void run() throws Exception {
        String[] parts = this.source.getName().split("\\.(?=[^\\.]+$)");
        String baseName = parts[0];
        String type = parts[1] == null ? "jar" : parts[1];
        MavenRemoteRepository jbossPublic = MavenRemoteRepositories.createRemoteRepository((String)"jboss-public-repository-group", (String)"http://repository.jboss.org/nexus/content/groups/public/", (String)"default");
        jbossPublic.setChecksumPolicy(MavenChecksumPolicy.CHECKSUM_POLICY_IGNORE);
        jbossPublic.setUpdatePolicy(MavenUpdatePolicy.UPDATE_POLICY_NEVER);
        ConfigurableMavenResolverSystem resolver = (ConfigurableMavenResolverSystem)((ConfigurableMavenResolverSystem)Maven.configureResolver().withMavenCentralRepo(true)).withRemoteRepo(jbossPublic);
        BuildTool tool = new BuildTool().artifactResolvingHelper((ArtifactResolvingHelper)new ShrinkwrapArtifactResolvingHelper(resolver)).projectArtifact("", baseName, "", type, this.source).resolveTransitiveDependencies(true);
        this.swarmDependencies.addAll(this.detectNeededFractions());
        for (String dep : this.swarmDependencies) {
            tool.dependency("compile", "org.wildfly.swarm", "wildfly-swarm-" + dep, this.version, "jar", null, null);
        }
        String jarName = this.name != null ? this.name : baseName;
        String outDir = this.outputDir.getCanonicalPath();
        System.err.println(String.format("Building %s/%s-swarm.jar with fractions: %s", outDir, jarName, String.join((CharSequence)", ", this.swarmDependencies)));
        tool.build(jarName, Paths.get(outDir, new String[0]));
    }
}

