/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.wildfly.swarm.cli.Build;

public class Main {
    private static final OptionParser OPT_PARSER = new OptionParser();
    private static final OptionSpec<Void> HELP_OPT = OPT_PARSER.acceptsAll(Arrays.asList("h", "help"), "print help and exit").forHelp();
    private static final OptionSpec<Void> VERSION_OPT = OPT_PARSER.acceptsAll(Arrays.asList("v", "version"), "print version and exit").forHelp();
    private static final OptionSpec<String> FRACTIONS_OPT = OPT_PARSER.acceptsAll(Arrays.asList("f", "fractions"), "swarm fractions to include").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("undertow,jaxrs,...");
    private static final OptionSpec<String> OUTPUT_DIR_OPT = OPT_PARSER.acceptsAll(Arrays.asList("o", "output-dir"), "directory where the final jar will be written").withRequiredArg().ofType(String.class).defaultsTo((Object)".", (Object[])new String[0]).describedAs("path");
    private static final OptionSpec<String> NAME_OPT = OPT_PARSER.acceptsAll(Arrays.asList("n", "name"), "The name of the final jar sans the -swarm.jar suffix (default: <source name>)").withRequiredArg().ofType(String.class).describedAs("jar-name");
    private static final OptionSpec<File> SOURCE_OPT = OPT_PARSER.nonOptions("The source artifact").ofType(File.class);
    private static final String VERSION;

    public static void main(String[] args) throws Exception {
        List nonOptArgs;
        OptionSet foundOptions = null;
        try {
            foundOptions = OPT_PARSER.parse(args);
        }
        catch (OptionException e) {
            System.err.println(e.getMessage() + "\n");
        }
        if (foundOptions == null || foundOptions.has(HELP_OPT)) {
            try {
                OPT_PARSER.printHelpOn((OutputStream)System.err);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            System.exit(0);
        }
        if (foundOptions.has(VERSION_OPT)) {
            Main.printAndExit("swarmtool v" + VERSION, 0);
        }
        if ((nonOptArgs = foundOptions.valuesOf(SOURCE_OPT)).isEmpty()) {
            Main.printAndExit("No source artifact specified.");
        }
        if (nonOptArgs.size() > 1) {
            Main.printAndExit("Too many source artifacts provided (" + nonOptArgs + ")");
        }
        File source = (File)nonOptArgs.get(0);
        new Build().source(source).swarmVersion(VERSION).addSwarmDependencies(foundOptions.valuesOf(FRACTIONS_OPT)).outputDir(new File((String)foundOptions.valueOf(OUTPUT_DIR_OPT))).name((String)foundOptions.valueOf(NAME_OPT)).run();
    }

    private static void printAndExit(String message) {
        Main.printAndExit(message, 1);
    }

    private static void printAndExit(String message, int code) {
        System.err.println(message);
        System.exit(code);
    }

    static {
        Properties props = new Properties();
        try (InputStream propStream = Main.class.getClassLoader().getResourceAsStream("META-INF/maven/org.wildfly.swarm/wildfly-swarm-cli/pom.properties");){
            props.load(propStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        VERSION = props.getProperty("version");
    }
}

