/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.selfcontained.ContentProvider;
import org.jboss.as.server.SelfContainedContainer;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.vfs.VirtualFile;
import org.wildfly.swarm.container.DefaultDeployment;
import org.wildfly.swarm.container.Deployment;
import org.wildfly.swarm.container.Fraction;
import org.wildfly.swarm.container.FractionDefaulter;
import org.wildfly.swarm.container.Interface;
import org.wildfly.swarm.container.PriorityComparator;
import org.wildfly.swarm.container.SimpleContentProvider;
import org.wildfly.swarm.container.SocketBindingGroup;

public class Container {
    private List<Fraction> fractions = new ArrayList<Fraction>();
    private List<SocketBindingGroup> socketBindingGroups = new ArrayList<SocketBindingGroup>();
    private List<Interface> interfaces = new ArrayList<Interface>();
    private SimpleContentProvider contentProvider = new SimpleContentProvider();
    private SelfContainedContainer container;
    private ModelControllerClient client;
    private State state = State.NOT_STARTED;

    public Container subsystem(Fraction fraction) {
        this.fractions.add(fraction);
        return this;
    }

    public Container iface(String name, String expression) {
        this.interfaces.add(new Interface(name, expression));
        return this;
    }

    public Container socketBindingGroup(SocketBindingGroup group) {
        this.socketBindingGroups.add(group);
        return this;
    }

    public synchronized Container start() throws Exception {
        this.state = State.STARTING;
        try {
            this.container = new SelfContainedContainer();
            this.applyDefaults();
            ArrayList<ModelNode> list = new ArrayList<ModelNode>();
            list.addAll(this.getList());
            ServiceContainer serviceContainer = this.container.start(list, (ContentProvider)this.contentProvider);
            ModelController controller = (ModelController)serviceContainer.getService(Services.JBOSS_SERVER_CONTROLLER).getValue();
            ExecutorService executor = Executors.newSingleThreadExecutor();
            this.client = controller.createClient((Executor)executor);
            this.state = State.STARTED;
            return this;
        }
        catch (Exception e) {
            this.state = State.NOT_STARTED;
            throw e;
        }
    }

    public synchronized void start(Deployment deployment) throws Exception {
        this.start();
        this.deploy(deployment);
    }

    public synchronized void deploy() throws Exception {
        this.deploy(new DefaultDeployment());
    }

    public synchronized void deploy(Deployment deployment) throws Exception {
        if (this.state != State.STARTED) {
            this.start();
        }
        VirtualFile contentFile = deployment.getContent();
        byte[] hash = this.contentProvider.addContent(contentFile);
        ModelNode deploymentAdd = new ModelNode();
        deploymentAdd.get("operation").set("add");
        deploymentAdd.get("address").set("deployment", deployment.getName());
        deploymentAdd.get("runtime-name").set(deployment.getName());
        deploymentAdd.get("enabled").set(true);
        ModelNode content = deploymentAdd.get("content").add();
        content.get("hash").set(hash);
        System.setProperty("wildfly.swarm.current.deployment", deployment.getName());
        ModelNode result = this.client.execute(deploymentAdd);
    }

    private void applyDefaults() throws Exception {
        this.applyInterfaceDefaults();
        this.applySocketBindingGroupDefaults();
        this.applySubsystemDefaults();
    }

    private void applySubsystemDefaults() throws Exception {
        HashMap defaulters = new HashMap();
        ServiceLoader<FractionDefaulter> loader = ServiceLoader.load(FractionDefaulter.class);
        for (FractionDefaulter each : loader) {
            defaulters.put(each.getSubsystemType(), each);
        }
        for (Fraction fraction : this.fractions) {
            defaulters.remove(fraction.getClass());
        }
        for (FractionDefaulter fractionDefaulter : defaulters.values()) {
            this.subsystem((Fraction)fractionDefaulter.getDefaultSubsystem());
        }
    }

    private void applyInterfaceDefaults() {
        if (this.interfaces.isEmpty()) {
            this.iface("public", "${jboss.bind.address:127.0.0.1}");
        }
    }

    private void applySocketBindingGroupDefaults() {
        if (this.socketBindingGroups.isEmpty()) {
            this.socketBindingGroup(new SocketBindingGroup("default-sockets", "public", "0").socketBinding("http", 8080));
        }
    }

    List<ModelNode> getList() {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        for (Interface interface_ : this.interfaces) {
            list.add(interface_.getNode());
        }
        for (SocketBindingGroup socketBindingGroup : this.socketBindingGroups) {
            list.addAll(socketBindingGroup.getList());
        }
        Collections.sort(this.fractions, new PriorityComparator());
        for (Fraction fraction : this.fractions) {
            List<ModelNode> sublist = fraction.getList();
            list.addAll(sublist);
        }
        return list;
    }

    private static enum State {
        NOT_STARTED,
        STARTING,
        STARTED;

    }
}

