/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.wildfly.swarm.container.Deployment;

public class DefaultDeployment
implements Deployment {
    @Override
    public String getName() {
        return System.getProperty("wildfly.swarm.app.name");
    }

    @Override
    public VirtualFile getContent() throws IOException {
        String path = System.getProperty("wildfly.swarm.app.path");
        File file = new File(path);
        VirtualFile mountPoint = VFS.getRootVirtualFile().getChild(file.getName());
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        TempFileProvider tempProvider = TempFileProvider.create((String)"wildfly-swarm", (ScheduledExecutorService)executor);
        VFS.mountZip((File)file, (VirtualFile)mountPoint, (TempFileProvider)tempProvider);
        DefaultDeployment.ensureJBossWebXml(mountPoint);
        return mountPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureJBossWebXml(VirtualFile archiveRoot) throws IOException {
        if (!archiveRoot.getName().endsWith(".war")) {
            return;
        }
        VirtualFile jbossWeb = archiveRoot.getChild("WEB-INF/jboss-web.xml");
        if (!jbossWeb.exists()) {
            File jbossWebTmp = File.createTempFile("jboss-web", "xml");
            try (FileWriter out = new FileWriter(jbossWebTmp);){
                out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<jboss-web>\n    <context-root>/</context-root>\n</jboss-web>");
            }
            VFS.mountReal((File)jbossWebTmp, (VirtualFile)jbossWeb);
        }
    }
}

