/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container;

import java.io.File;
import java.io.IOException;
import org.jboss.modules.ArtifactLoaderFactory;
import org.jboss.modules.ProjectDependencies;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.wildfly.swarm.container.Deployment;

public class DependencyDeployment
implements Deployment {
    private final File file;
    private final String name;

    protected static String name(String gav) {
        String[] parts = gav.split(":");
        if (parts.length >= 2) {
            return parts[1] + ".jar";
        }
        return gav;
    }

    public DependencyDeployment(String gav) throws IOException {
        this(gav, DependencyDeployment.name(gav));
    }

    public DependencyDeployment(String gav, String name) throws IOException {
        String versionedGav = ProjectDependencies.getProjectDependencies().getVersionedGAV(gav);
        this.file = ArtifactLoaderFactory.INSTANCE.getFile(versionedGav);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VirtualFile getContent() throws IOException {
        VirtualFile mountPoint = VFS.getRootVirtualFile().getChild(this.name);
        VFS.mountReal((File)this.file, (VirtualFile)mountPoint);
        return mountPoint;
    }
}

