/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ValueExpression;

public class SocketBindingGroup {
    private final List<ModelNode> list = new ArrayList<ModelNode>();
    private final PathAddress address;

    public SocketBindingGroup(String name, String defaultInterface, String portOffsetExpression) {
        ModelNode node = new ModelNode();
        this.address = PathAddress.pathAddress((String)"socket-binding-group", (String)name);
        node.get("operation").set("add");
        node.get("address").set(this.address.toModelNode());
        node.get("default-interface").set(defaultInterface);
        node.get("port-offset").set(new ValueExpression(portOffsetExpression));
        this.list.add(node);
    }

    public SocketBindingGroup socketBinding(String name, String portExpression) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.address.append("socket-binding", name).toModelNode());
        node.get("operation").set("add");
        node.get("port").set(new ValueExpression(portExpression));
        this.list.add(node);
        return this;
    }

    public SocketBindingGroup socketBinding(String name, int port) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.address.append("socket-binding", name).toModelNode());
        node.get("operation").set("add");
        node.get("port").set(port);
        this.list.add(node);
        return this;
    }

    public List<ModelNode> getList() {
        return this.list;
    }
}

