/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.jboss.modules.ModuleLoadException;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.importer.zip.ZipImporterImpl;
import org.wildfly.swarm.container.Container;
import org.wildfly.swarm.container.WarDeployment;

public class DefaultWarDeployment
extends WarDeployment {
    public DefaultWarDeployment(Container container) throws IOException, ModuleLoadException {
        this((WebArchive)container.getShrinkWrapDomain().getArchiveFactory().create(WebArchive.class));
    }

    public DefaultWarDeployment(WebArchive archive) throws IOException, ModuleLoadException {
        super(archive);
        this.setup();
    }

    protected void setup() throws IOException, ModuleLoadException {
        boolean result = this.setupUsingAppPath() || this.setupUsingAppArtifact() || this.setupUsingMaven();
    }

    protected boolean setupUsingAppPath() throws IOException {
        String appPath = System.getProperty("wildfly.swarm.app.path");
        if (appPath != null) {
            final Path path = Paths.get(System.getProperty("wildfly.swarm.app.path"), new String[0]);
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path simple = path.relativize(file);
                        DefaultWarDeployment.this.archive.add((Asset)new FileAsset(file.toFile()), DefaultWarDeployment.this.convertSeparators(simple));
                        return super.visitFile(file, attrs);
                    }
                });
            } else {
                ZipImporterImpl importer = new ZipImporterImpl((Archive)this.archive);
                importer.importFrom(new File(System.getProperty("wildfly.swarm.app.path")));
            }
            return true;
        }
        return false;
    }

    protected boolean setupUsingAppArtifact() throws IOException {
        String appArtifact = System.getProperty("wildfly.swarm.app.artifact");
        if (appArtifact != null) {
            try (InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream("_bootstrap/" + appArtifact);){
                System.err.println("loading app artifact");
                ZipImporterImpl importer = new ZipImporterImpl((Archive)this.archive);
                importer.importFrom(in);
            }
            return true;
        }
        return false;
    }

    protected boolean setupUsingMaven() throws IOException {
        Path webapp;
        Path pwd = Paths.get(System.getProperty("user.dir"), new String[0]);
        final Path classes = pwd.resolve("target").resolve("classes");
        boolean success = false;
        if (Files.exists(classes, new LinkOption[0])) {
            success = true;
            Files.walkFileTree(classes, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path simple = classes.relativize(file);
                    DefaultWarDeployment.this.archive.add((Asset)new FileAsset(file.toFile()), "WEB-INF/classes/" + DefaultWarDeployment.this.convertSeparators(simple));
                    return super.visitFile(file, attrs);
                }
            });
        }
        if (Files.exists(webapp = pwd.resolve("src").resolve("main").resolve("webapp"), new LinkOption[0])) {
            success = true;
            Files.walkFileTree(webapp, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path simple = webapp.relativize(file);
                    DefaultWarDeployment.this.archive.add((Asset)new FileAsset(file.toFile()), DefaultWarDeployment.this.convertSeparators(simple));
                    return super.visitFile(file, attrs);
                }
            });
        }
        this.addJavaClassPathToWebInfLib();
        return success;
    }

    protected String convertSeparators(Path path) {
        String convertedPath = path.toString();
        if (convertedPath.contains(File.separator)) {
            convertedPath = convertedPath.replace(File.separator, "/");
        }
        return convertedPath;
    }
}

