/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.ConfigurationBuilder;
import org.jboss.shrinkwrap.api.Domain;
import org.jboss.shrinkwrap.api.ExtensionLoader;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.wildfly.swarm.bootstrap.modules.BootModuleLoader;
import org.wildfly.swarm.container.DefaultWarDeployment;
import org.wildfly.swarm.container.Deployer;
import org.wildfly.swarm.container.Deployment;
import org.wildfly.swarm.container.Fraction;
import org.wildfly.swarm.container.Interface;
import org.wildfly.swarm.container.Server;
import org.wildfly.swarm.container.ShrinkWrapExtensionLoader;
import org.wildfly.swarm.container.SocketBindingGroup;

public class Container {
    private Map<Class<? extends Fraction>, Fraction> fractions = new ConcurrentHashMap<Class<? extends Fraction>, Fraction>();
    private List<Fraction> dependentFractions = new ArrayList<Fraction>();
    private Set<Class<? extends Fraction>> defaultFractionTypes = new HashSet<Class<? extends Fraction>>();
    private List<SocketBindingGroup> socketBindingGroups = new ArrayList<SocketBindingGroup>();
    private List<Interface> interfaces = new ArrayList<Interface>();
    private Server server;
    private Deployer deployer;
    private Domain domain;

    public Container() throws Exception {
        this.createServer();
        this.createShrinkWrapDomain();
    }

    public Domain getShrinkWrapDomain() {
        return this.domain;
    }

    private void createShrinkWrapDomain() throws ModuleLoadException {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.extensionLoader((ExtensionLoader)new ShrinkWrapExtensionLoader());
        HashSet<Object> classLoaders = new HashSet<Object>();
        classLoaders.add(Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.wildfly.swarm.bootstrap")).getClassLoader());
        classLoaders.add(ClassLoader.getSystemClassLoader());
        builder.classLoaders(classLoaders);
        Configuration config = builder.build();
        this.domain = ShrinkWrap.createDomain((Configuration)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createServer() throws Exception {
        if (System.getProperty("boot.module.loader") == null) {
            System.setProperty("boot.module.loader", BootModuleLoader.class.getName());
        }
        Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.wildfly.swarm.runtime.container"));
        Class serverClass = module.getClassLoader().loadClass("org.wildfly.swarm.runtime.container.RuntimeServer");
        this.server = (Server)serverClass.newInstance();
        Module loggingModule = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.wildfly.swarm.runtime.logging"));
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)loggingModule.getClassLoader());
            System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
            Logger.getGlobal();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }

    public void applyFractionDefaults(Server server) throws Exception {
        Set<Class<? extends Fraction>> availFractions = server.getFractionTypes();
        if (!this.dependentFractions.isEmpty()) {
            this.dependentFractions.stream().filter(dependentFraction -> this.fractions.get(dependentFraction.getClass()) == null).forEach(this::fraction);
            this.dependentFractions.clear();
        }
        availFractions.stream().filter(fractionClass -> this.fractions.get(fractionClass) == null).forEach(fractionClass -> this.fractionDefault(server.createDefaultFor((Class<? extends Fraction>)fractionClass)));
        if (!this.dependentFractions.isEmpty()) {
            this.dependentFractions.stream().filter(dependentFraction -> this.fractions.get(dependentFraction.getClass()) == null || this.fractions.get(dependentFraction.getClass()) != null && this.defaultFractionTypes.contains(dependentFraction.getClass())).forEach(this::fraction);
            this.dependentFractions.clear();
        }
    }

    public Container subsystem(Fraction fraction) {
        return this.fraction(fraction);
    }

    public Container fraction(Fraction fraction) {
        this.fractions.put(this.fractionRoot(fraction.getClass()), fraction);
        fraction.initialize(new InitContext());
        return this;
    }

    public List<Fraction> fractions() {
        return this.fractions.values().stream().collect(Collectors.toList());
    }

    private void fractionDefault(Fraction defaultFraction) {
        this.defaultFractionTypes.add(this.fractionRoot(defaultFraction.getClass()));
        this.fraction(defaultFraction);
    }

    private Class<? extends Fraction> fractionRoot(Class<? extends Fraction> fractionClass) {
        Class<? extends Fraction> fractionRoot = fractionClass;
        boolean rootFound = false;
        while (!rootFound) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = fractionRoot.getInterfaces()) {
                if (!anInterface.getName().equals(Fraction.class.getName())) continue;
                rootFound = true;
                break;
            }
            if (rootFound) continue;
            fractionRoot = fractionRoot.getSuperclass();
        }
        return fractionRoot;
    }

    private void dependentFraction(Fraction fraction) {
        this.dependentFractions.add(fraction);
    }

    public Container iface(String name, String expression) {
        this.interfaces.add(new Interface(name, expression));
        return this;
    }

    public List<Interface> ifaces() {
        return this.interfaces;
    }

    public Container socketBindingGroup(SocketBindingGroup group) {
        this.socketBindingGroups.add(group);
        return this;
    }

    public List<SocketBindingGroup> socketBindingGroups() {
        return this.socketBindingGroups;
    }

    public Container start() throws Exception {
        this.deployer = this.server.start(this);
        return this;
    }

    public Container stop() throws Exception {
        this.server.stop();
        return this;
    }

    public Container start(Deployment deployment) throws Exception {
        return this.start().deploy(deployment);
    }

    public <T extends Archive> T create(String name, Class<T> type) {
        Archive archive = (Archive)this.domain.getArchiveFactory().create(type, name);
        return (T)archive;
    }

    public Container deploy() throws Exception {
        return this.deploy(new DefaultWarDeployment(this));
    }

    public Container deploy(Archive deployment) throws Exception {
        this.deployer.deploy(deployment);
        return this;
    }

    public Container deploy(Deployment deployment) throws Exception {
        return this.deploy(deployment.getArchive(true));
    }

    public class InitContext {
        public void fraction(Fraction fraction) {
            Container.this.dependentFraction(fraction);
        }
    }
}

