/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.modules.MavenArtifactUtil;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.importer.zip.ZipImporterImpl;
import org.wildfly.swarm.container.Container;
import org.wildfly.swarm.container.Deployment;

public class DependencyDeployment
implements Deployment {
    private final Archive archive;
    private final String name;

    public DependencyDeployment(Container container, String gav) throws Exception {
        this(container, gav, DependencyDeployment.name(gav));
    }

    public DependencyDeployment(Container container, String gav, String name) throws Exception {
        this.archive = container.create(name, JavaArchive.class);
        new ZipImporterImpl(this.archive).importFrom(DependencyDeployment.findFile(gav));
        this.name = name;
    }

    protected static String name(String gav) {
        String[] parts = gav.split(":");
        if (parts.length >= 2) {
            return parts[1] + ".jar";
        }
        return gav;
    }

    private static File findFile(String gav) throws IOException, ModuleLoadException {
        String[] parts = gav.split(":");
        if (parts.length < 2) {
            throw new RuntimeException("GAV must includes at least 2 segments");
        }
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = null;
        String classifier = "";
        if (parts.length > 3) {
            classifier = parts[3];
        }
        if ((version = parts.length > 2 ? parts[2] : DependencyDeployment.determineVersionViaModule(groupId, artifactId, classifier)) == null) {
            version = DependencyDeployment.determineVersionViaClasspath(groupId, artifactId, classifier);
        }
        if (version == null) {
            throw new RuntimeException("Unable to determine version number from 2-part GAV.  Try three!");
        }
        return MavenArtifactUtil.resolveJarArtifact((String)(groupId + ":" + artifactId + ":" + version + (classifier == null ? "" : ":" + classifier)));
    }

    private static String determineVersionViaModule(String groupId, String artifactId, String classifier) throws ModuleLoadException {
        Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"APP", (String)"dependencies"));
        return module.getProperty("version." + groupId + ":" + artifactId + "::" + classifier);
    }

    private static String determineVersionViaClasspath(String groupId, String artifactId, String classifier) {
        String regexp = ".*" + artifactId + "-(.+)" + (classifier.length() == 0 ? "" : "-" + classifier) + ".jar";
        Pattern pattern = Pattern.compile(regexp);
        String classpath = System.getProperty("java.class.path");
        String[] elements = classpath.split(File.pathSeparator);
        for (int i = 0; i < elements.length; ++i) {
            Matcher matcher = pattern.matcher(elements[i]);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public Archive getArchive() {
        return this.getArchive(false);
    }

    @Override
    public Archive getArchive(boolean finalize) {
        return this.archive;
    }
}

