/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.modules.MavenArtifactUtil;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.importer.zip.ZipImporterImpl;

public class ArtifactManager {
    public static JavaArchive artifact(String gav) throws IOException, ModuleLoadException {
        File file = ArtifactManager.findFile(gav);
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)file.getName());
        new ZipImporterImpl((Archive)archive).importFrom(file);
        return archive;
    }

    public static JavaArchive artifact(String gav, String asName) throws IOException, ModuleLoadException {
        File file = ArtifactManager.findFile(gav);
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)asName);
        new ZipImporterImpl((Archive)archive).importFrom(file);
        return archive;
    }

    public static List<JavaArchive> allArtifacts() throws IOException {
        ArrayList<JavaArchive> archives = new ArrayList<JavaArchive>();
        InputStream depsTxt = ClassLoader.getSystemClassLoader().getResourceAsStream("META-INF/wildfly-swarm-dependencies.txt");
        if (depsTxt != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(depsTxt));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    File artifact = MavenArtifactUtil.resolveJarArtifact((String)line);
                    JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)artifact.getName());
                    new ZipImporterImpl((Archive)archive).importFrom(artifact);
                    archives.add(archive);
                }
            }
        } else {
            String classpath = System.getProperty("java.class.path");
            String javaHome = System.getProperty("java.home");
            Path pwd = Paths.get(System.getProperty("user.dir"), new String[0]);
            if (classpath != null) {
                String[] elements = classpath.split(File.pathSeparator);
                for (int i = 0; i < elements.length; ++i) {
                    JavaArchive archive;
                    if (elements[i].startsWith(javaHome)) continue;
                    File artifact = new File(elements[i]);
                    if (artifact.isFile()) {
                        archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)artifact.getName());
                        new ZipImporterImpl((Archive)archive).importFrom(artifact);
                        archives.add(archive);
                        continue;
                    }
                    if (artifact.toPath().startsWith(pwd)) continue;
                    archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
                    final Path basePath = artifact.toPath();
                    Files.walkFileTree(basePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            archive.add((Asset)new FileAsset(file.toFile()), basePath.relativize(file).toString());
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    archives.add(archive);
                }
            }
        }
        return archives;
    }

    private static File findFile(String gav) throws IOException, ModuleLoadException {
        String[] parts = gav.split(":");
        if (parts.length < 2) {
            throw new RuntimeException("GAV must includes at least 2 segments");
        }
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = null;
        String classifier = "";
        if (parts.length > 3) {
            classifier = parts[3];
        }
        if ((version = parts.length > 2 ? parts[2] : ArtifactManager.determineVersionViaModule(groupId, artifactId, classifier)) == null) {
            version = ArtifactManager.determineVersionViaClasspath(groupId, artifactId, classifier);
        }
        if (version == null) {
            throw new RuntimeException("Unable to determine version number from 2-part GAV.  Try three!");
        }
        return MavenArtifactUtil.resolveJarArtifact((String)(groupId + ":" + artifactId + ":" + version + (classifier == null ? "" : ":" + classifier)));
    }

    private static String determineVersionViaModule(String groupId, String artifactId, String classifier) throws ModuleLoadException {
        Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"APP", (String)"dependencies"));
        return module.getProperty("version." + groupId + ":" + artifactId + "::" + classifier);
    }

    private static String determineVersionViaClasspath(String groupId, String artifactId, String classifier) {
        String regexp = ".*" + artifactId + "-(.+)" + (classifier.length() == 0 ? "" : "-" + classifier) + ".jar";
        Pattern pattern = Pattern.compile(regexp);
        String classpath = System.getProperty("java.class.path");
        String[] elements = classpath.split(File.pathSeparator);
        for (int i = 0; i < elements.length; ++i) {
            Matcher matcher = pattern.matcher(elements[i]);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }
}

