/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.jboss.shrinkwrap.api.asset.Asset;

public class JBossDeploymentStructureAsset
implements Asset {
    private static final String JBOSS_DEPLOYMENT_STRUCTURE_CONTENTS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>  \n<jboss-deployment-structure>  \n    <deployment>  \n         <dependencies>  \n              ${MODULES}\n        </dependencies>  \n    </deployment>  \n</jboss-deployment-structure>\n";
    private Set<String> modules = new HashSet<String>();

    public void addModule(String name, String slot) {
        this.modules.add(name + ":" + slot);
    }

    public InputStream openStream() {
        StringBuilder modules = new StringBuilder();
        for (String each : this.modules) {
            String[] parts = each.split(":");
            modules.append("              <module name=\"" + parts[0] + "\" slot=\"" + parts[1] + "\"/>\n");
        }
        String structureContents = JBOSS_DEPLOYMENT_STRUCTURE_CONTENTS.replace("${MODULES}", modules.toString().trim());
        return new ByteArrayInputStream(structureContents.getBytes());
    }
}

