/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.log.ModuleLogger;
import org.jboss.modules.log.StreamModuleLogger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Domain;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.exporter.zip.ZipExporterImpl;
import org.jboss.shrinkwrap.impl.base.spec.JavaArchiveImpl;
import org.jboss.shrinkwrap.impl.base.spec.WebArchiveImpl;
import org.wildfly.swarm.bootstrap.modules.BootModuleLoader;
import org.wildfly.swarm.container.DefaultDeploymentFactory;
import org.wildfly.swarm.container.Deployer;
import org.wildfly.swarm.container.Fraction;
import org.wildfly.swarm.container.Interface;
import org.wildfly.swarm.container.Server;
import org.wildfly.swarm.container.SocketBinding;
import org.wildfly.swarm.container.SocketBindingGroup;

public class Container {
    private Map<Class<? extends Fraction>, Fraction> fractions = new ConcurrentHashMap<Class<? extends Fraction>, Fraction>();
    private Map<String, Fraction> fractionsBySimpleName = new ConcurrentHashMap<String, Fraction>();
    private List<Fraction> dependentFractions = new ArrayList<Fraction>();
    private Set<Class<? extends Fraction>> defaultFractionTypes = new HashSet<Class<? extends Fraction>>();
    private List<SocketBindingGroup> socketBindingGroups = new ArrayList<SocketBindingGroup>();
    private Map<String, List<SocketBinding>> socketBindings = new HashMap<String, List<SocketBinding>>();
    private List<Interface> interfaces = new ArrayList<Interface>();
    private Server server;
    private Deployer deployer;
    private Domain domain;
    private String[] args;

    public Container() throws Exception {
        this(false);
    }

    public Container(boolean debugBootstrap) throws Exception {
        this.createServer(debugBootstrap);
        this.createShrinkWrapDomain();
    }

    private void createShrinkWrapDomain() throws ModuleLoadException {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            if (Container.isFatJar()) {
                Thread.currentThread().setContextClassLoader(Container.class.getClassLoader());
                Module appModule = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"swarm.application"));
                Thread.currentThread().setContextClassLoader((ClassLoader)appModule.getClassLoader());
            }
            this.domain = ShrinkWrap.getDefaultDomain();
            this.domain.getConfiguration().getExtensionLoader().addOverride(ZipExporter.class, ZipExporterImpl.class);
            this.domain.getConfiguration().getExtensionLoader().addOverride(JavaArchive.class, JavaArchiveImpl.class);
            this.domain.getConfiguration().getExtensionLoader().addOverride(WebArchive.class, WebArchiveImpl.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }

    private void createServer(boolean debugBootstrap) throws Exception {
        if (System.getProperty("boot.module.loader") == null) {
            System.setProperty("boot.module.loader", BootModuleLoader.class.getName());
        }
        if (debugBootstrap) {
            Module.setModuleLogger((ModuleLogger)new StreamModuleLogger(System.err));
        }
        Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.wildfly.swarm.container", (String)"runtime"));
        Class serverClass = module.getClassLoader().loadClass("org.wildfly.swarm.container.runtime.RuntimeServer");
        try {
            this.server = (Server)serverClass.newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void applyFractionDefaults(Server server) throws Exception {
        Set<Class<? extends Fraction>> availFractions = server.getFractionTypes();
        if (!this.dependentFractions.isEmpty()) {
            this.dependentFractions.stream().filter(dependentFraction -> this.fractions.get(dependentFraction.getClass()) == null).forEach(this::fraction);
            this.dependentFractions.clear();
        }
        availFractions.stream().filter(fractionClass -> this.fractions.get(fractionClass) == null).forEach(fractionClass -> this.fractionDefault(server.createDefaultFor((Class<? extends Fraction>)fractionClass)));
        if (!this.dependentFractions.isEmpty()) {
            this.dependentFractions.stream().filter(dependentFraction -> this.fractions.get(dependentFraction.getClass()) == null || this.fractions.get(dependentFraction.getClass()) != null && this.defaultFractionTypes.contains(dependentFraction.getClass())).forEach(this::fraction);
            this.dependentFractions.clear();
        }
    }

    public Container fraction(Fraction fraction) {
        if (fraction != null) {
            this.fractions.put(this.fractionRoot(fraction.getClass()), fraction);
            this.fractionsBySimpleName.put(fraction.simpleName(), fraction);
            fraction.initialize(new InitContext());
        }
        return this;
    }

    public List<Fraction> fractions() {
        return this.fractions.values().stream().collect(Collectors.toList());
    }

    private void fractionDefault(Fraction defaultFraction) {
        if (defaultFraction == null) {
            return;
        }
        this.defaultFractionTypes.add(this.fractionRoot(defaultFraction.getClass()));
        this.fraction(defaultFraction);
    }

    private Class<? extends Fraction> fractionRoot(Class<? extends Fraction> fractionClass) {
        Class<? extends Fraction> fractionRoot = fractionClass;
        boolean rootFound = false;
        while (!rootFound) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = fractionRoot.getInterfaces()) {
                if (!anInterface.getName().equals(Fraction.class.getName())) continue;
                rootFound = true;
                break;
            }
            if (rootFound) continue;
            fractionRoot = fractionRoot.getSuperclass();
        }
        return fractionRoot;
    }

    private void dependentFraction(Fraction fraction) {
        this.dependentFractions.add(fraction);
    }

    public Container iface(String name, String expression) {
        this.interfaces.add(new Interface(name, expression));
        return this;
    }

    public List<Interface> ifaces() {
        return this.interfaces;
    }

    public Container socketBindingGroup(SocketBindingGroup group) {
        this.socketBindingGroups.add(group);
        return this;
    }

    public List<SocketBindingGroup> socketBindingGroups() {
        return this.socketBindingGroups;
    }

    public SocketBindingGroup getSocketBindingGroup(String name) {
        for (SocketBindingGroup each : this.socketBindingGroups) {
            if (!each.name().equals(name)) continue;
            return each;
        }
        return null;
    }

    public Map<String, List<SocketBinding>> socketBindings() {
        return this.socketBindings;
    }

    void socketBinding(SocketBinding binding) {
        this.socketBinding("default-sockets", binding);
    }

    void socketBinding(String groupName, SocketBinding binding) {
        List<SocketBinding> list = this.socketBindings.get(groupName);
        if (list == null) {
            list = new ArrayList<SocketBinding>();
            this.socketBindings.put(groupName, list);
        }
        for (SocketBinding each : list) {
            if (!each.name().equals(binding.name())) continue;
            throw new RuntimeException("Socket binding '" + binding.name() + "' already configured for '" + each.portExpression() + "'");
        }
        list.add(binding);
    }

    public Container start() throws Exception {
        this.deployer = this.server.start(this);
        return this;
    }

    public Container stop() throws Exception {
        this.server.stop();
        return this;
    }

    public Container start(Archive deployment) throws Exception {
        return this.start().deploy(deployment);
    }

    public Container deploy() throws Exception {
        Archive deployment = this.createDefaultDeployment();
        if (deployment == null) {
            System.err.println("[WARN] Unable to create default deployment");
            return this;
        }
        return this.deploy(deployment);
    }

    public Container deploy(Archive deployment) throws Exception {
        this.deployer.deploy(deployment);
        return this;
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public PostInitContext createPostInitContext() {
        return new PostInitContext();
    }

    protected Archive createDefaultDeployment() throws Exception {
        Module m1 = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"swarm.application"));
        ServiceLoader<DefaultDeploymentFactory> providerLoader = m1.loadService(DefaultDeploymentFactory.class);
        Iterator<Object> providerIter = providerLoader.iterator();
        if (!providerIter.hasNext()) {
            providerLoader = ServiceLoader.load(DefaultDeploymentFactory.class, ClassLoader.getSystemClassLoader());
            providerIter = providerLoader.iterator();
        }
        HashMap<String, DefaultDeploymentFactory> factories = new HashMap<String, DefaultDeploymentFactory>();
        while (providerIter.hasNext()) {
            DefaultDeploymentFactory factory = (DefaultDeploymentFactory)providerIter.next();
            DefaultDeploymentFactory current = (DefaultDeploymentFactory)factories.get(factory.getType());
            if (current == null) {
                factories.put(factory.getType(), factory);
                continue;
            }
            if (factory.getPriority() <= current.getPriority()) continue;
            factories.put(factory.getType(), factory);
        }
        String type = this.determineDeploymentType();
        DefaultDeploymentFactory factory = (DefaultDeploymentFactory)factories.get(type);
        if (factory != null) {
            return factory.create(this);
        }
        return null;
    }

    protected String determineDeploymentType() throws IOException {
        String line2;
        Throwable throwable;
        int dotLoc;
        String artifact = System.getProperty("wildfly.swarm.app.path");
        if (artifact != null && (dotLoc = artifact.lastIndexOf(46)) >= 0) {
            return artifact.substring(dotLoc + 1);
        }
        artifact = System.getProperty("wildfly.swarm.app.artifact");
        if (artifact != null && (dotLoc = artifact.lastIndexOf(46)) >= 0) {
            return artifact.substring(dotLoc + 1);
        }
        if (Files.exists(Paths.get("pom.xml", new String[0]), new LinkOption[0])) {
            throwable = null;
            try (BufferedReader in = new BufferedReader(new FileReader(Paths.get("pom.xml", new String[0]).toFile()));){
                line2 = null;
                while ((line2 = in.readLine()) != null) {
                    if ((line2 = line2.trim()).equals("<packaging>jar</packaging>")) {
                        String string = "jar";
                        return string;
                    }
                    if (!line2.equals("<packaging>war</packaging>")) continue;
                    String string = "war";
                    return string;
                }
            }
            catch (Throwable line2) {
                throwable = line2;
                throw line2;
            }
        }
        if (Files.exists(Paths.get("Mavenfile", new String[0]), new LinkOption[0])) {
            throwable = null;
            try (BufferedReader in = new BufferedReader(new FileReader(Paths.get("Mavenfile", new String[0]).toFile()));){
                line2 = null;
                while ((line2 = in.readLine()) != null) {
                    if ((line2 = line2.trim()).equals("packaging :jar")) {
                        String string = "jar";
                        return string;
                    }
                    if (!line2.equals("packaging :war")) continue;
                    String string = "war";
                    return string;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        return "unknown";
    }

    public static boolean isFatJar() throws IOException {
        block34: {
            URL location = Container.class.getProtectionDomain().getCodeSource().getLocation();
            Path root = null;
            if (location.getProtocol().equals("file")) {
                try {
                    root = Paths.get(location.toURI());
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
            } else if (location.toExternalForm().startsWith("jar:file:")) {
                return true;
            }
            if (Files.isRegularFile(root, new LinkOption[0])) {
                try (JarFile jar = new JarFile(root.toFile());){
                    ZipEntry propsEntry = jar.getEntry("META-INF/wildfly-swarm.properties");
                    if (propsEntry == null) break block34;
                    try (InputStream in = jar.getInputStream(propsEntry);){
                        Properties props = new Properties();
                        props.load(in);
                        if (props.containsKey("wildfly.swarm.app.artifact")) {
                            System.setProperty("wildfly.swarm.app.artifact", props.getProperty("wildfly.swarm.app.artifact"));
                        }
                        Enumeration<?> names = props.propertyNames();
                        while (names.hasMoreElements()) {
                            String name = (String)names.nextElement();
                            String value = props.getProperty(name);
                            if (System.getProperty(name) != null) continue;
                            System.setProperty(name, value);
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public class PostInitContext
    extends InitContext {
        public boolean hasFraction(String simpleName) {
            return Container.this.fractions().stream().anyMatch(f -> f.simpleName().equalsIgnoreCase(simpleName));
        }

        public Fraction fraction(String simpleName) {
            System.err.println(simpleName + " vs " + Container.this.fractions());
            Optional<Fraction> opt = Container.this.fractions().stream().filter(f -> f.simpleName().equalsIgnoreCase(simpleName)).findFirst();
            return opt.orElse(null);
        }
    }

    public class InitContext {
        public void fraction(Fraction fraction) {
            Container.this.dependentFraction(fraction);
        }

        public void socketBinding(SocketBinding binding) {
            this.socketBinding("default-sockets", binding);
        }

        public void socketBinding(String groupName, SocketBinding binding) {
            Container.this.socketBinding(groupName, binding);
        }
    }
}

