/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.datasources;

import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;

public class Datasource {
    private final String name;
    private String connectionUrl;
    private String driverName;
    private String userName;
    private String password;

    public Datasource(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Datasource connectionURL(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    public String getConnectionURL() {
        return this.connectionUrl;
    }

    public Datasource driver(String driverName) {
        this.driverName = driverName;
        return this;
    }

    public String getDriver() {
        return this.driverName;
    }

    public Datasource authentication(String userName, String password) {
        this.userName = userName;
        this.password = password;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getJNDIName() {
        return "java:jboss/datasources/" + this.name;
    }

    ModelNode get(PathAddress address) {
        ModelNode node = new ModelNode();
        node.get("address").set(address.append("data-source", this.name).toModelNode());
        node.get("operation").set("add");
        node.get("enabled").set(true);
        node.get("jndi-name").set(this.getJNDIName());
        node.get("use-java-context").set(true);
        node.get("connection-url").set(this.connectionUrl);
        node.get("driver-name").set(this.driverName);
        if (this.userName != null) {
            node.get("user-name").set(this.userName);
        }
        if (this.password != null) {
            node.get("password").set(this.password);
        }
        return node;
    }
}

