/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.datasources;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.wildfly.swarm.container.Deployment;
import org.wildfly.swarm.container.util.XmlWriter;
import org.wildfly.swarm.datasources.Datasource;

public class DatasourceDeployment
implements Deployment {
    private final Datasource ds;

    public DatasourceDeployment(Datasource ds) {
        this.ds = ds;
    }

    public String getName() {
        return this.ds.getName() + "-ds.xml";
    }

    public VirtualFile getContent() throws IOException {
        VirtualFile mountPoint = VFS.getRootVirtualFile().getChild(this.getName());
        File dsXml = File.createTempFile(this.getName(), "-ds.xml");
        try (XmlWriter out = new XmlWriter((Writer)new FileWriter(dsXml));){
            XmlWriter.Element datasources = out.element("datasources").attr("xmlns", "http://www.jboss.org/ironjacamar/schema").attr("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").attr("xsi:schemaLocation", "http://www.jboss.org/ironjacamar/schema http://docs.jboss.org/ironjacamar/schema/datasources_1_0.xsd");
            XmlWriter.Element datasource = datasources.element("datasource").attr("jndi-name", this.ds.getJNDIName()).attr("enabled", "true").attr("use-java-context", "true").attr("pool-name", this.ds.getName());
            datasource.element("connection-url").content(this.ds.getConnectionURL()).end();
            datasource.element("driver").content(this.ds.getDriver()).end();
            XmlWriter.Element security = datasource.element("security");
            security.element("user-name").content(this.ds.getUserName()).end();
            security.element("password").content(this.ds.getPassword()).end();
            security.end();
            datasource.end();
            datasources.end();
            out.close();
        }
        VFS.mountReal((File)dsXml, (VirtualFile)mountPoint);
        return mountPoint;
    }
}

