/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.ejb.runtime;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.wildfly.swarm.container.runtime.AbstractServerConfiguration;
import org.wildfly.swarm.ejb.EJBFraction;

public class EJBConfiguration
extends AbstractServerConfiguration<EJBFraction> {
    private PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"ejb3")});

    public EJBConfiguration() {
        super(EJBFraction.class);
    }

    public EJBFraction defaultFraction() {
        return new EJBFraction();
    }

    public List<ModelNode> getList(EJBFraction fraction) {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        ModelNode node = new ModelNode();
        node.get("address").set("extension", "org.jboss.as.ejb3");
        node.get("operation").set("add");
        list.add(node);
        node = new ModelNode();
        node.get("address").set(this.address.toModelNode());
        node.get("operation").set("add");
        node.get("default-stateful-bean-access-timeout").set(5000);
        node.get("default-sfsb-cache").set("simple");
        node.get("default-sfsb-passivation-disabled-cache").set("simple");
        node.get("default-singleton-bean-access-timeout").set(5000);
        node.get("default-security-domain").set("other");
        node.get("default-missing-method-permissions-deny-access").set("true");
        node.get("log-system-exceptions").set("true");
        list.add(node);
        this.setBeanPools(list);
        this.setCache(list);
        node = new ModelNode();
        node.get("address").set(this.address.append("service", "async").toModelNode());
        node.get("operation").set("add");
        node.get("thread-pool-name").set("default");
        list.add(node);
        this.setTimerService(list);
        this.setThreadPool(list);
        return list;
    }

    private void setBeanPools(List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.address.append("strict-max-bean-instance-pool", "slsb-strict-max-pool").toModelNode());
        node.get("operation").set("add");
        node.get("max-pool-size").set(20);
        node.get("timeout").set(5);
        node.get("timeout-unit").set("MINUTES");
        list.add(node);
        node = new ModelNode();
        node.get("address").set(this.address.append("strict-max-bean-instance-pool", "mdb-strict-max-pool").toModelNode());
        node.get("operation").set("add");
        node.get("max-pool-size").set(20);
        node.get("timeout").set(5);
        node.get("timeout-unit").set("MINUTES");
        list.add(node);
    }

    private void setCache(List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.address.append("cache", "simple").toModelNode());
        node.get("operation").set("add");
        list.add(node);
    }

    private void setThreadPool(List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.address.append("thread-pool", "default").toModelNode());
        node.get("operation").set("add");
        node.get("max-threads").set(10);
        node.get("keepalive-time").get("time").set(100);
        node.get("keepalive-time").get("unit").set("MILLISECONDS");
        list.add(node);
    }

    private void setTimerService(List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.address.append("service", "timer-service").toModelNode());
        node.get("operation").set("add");
        node.get("thread-pool-name").set("default");
        node.get("default-data-store").set("default-file-store");
        list.add(node);
        node = new ModelNode();
        node.get("address").set(this.address.append("service", "timer-service").append("file-data-store", "default-file-store").toModelNode());
        node.get("operation").set("add");
        node.get("path").set("timer-service-data");
        node.get("relative-to").set("jboss.server.data.dir");
        list.add(node);
    }
}

